import ICmd from "../../../common/cmd/ICmd";
import IXmlEntity from "../../../common/xml/IXmlEntity";
import ITagNode from "../../../common/xml/node/ITagNode";
import WfConstants from "../base/WfConstants";

export default class ChangeLineFromNodeCmd implements ICmd {

    private xmlEntity: IXmlEntity;

    private fromTag: ITagNode;

    private toLinkTag: ITagNode;

    private orgFromTag: ITagNode;

    constructor(xmlEntity: IXmlEntity, fromTag: ITagNode, orgFromTag: ITagNode, toLinkTag: ITagNode) {
        this.xmlEntity = xmlEntity;
        this.fromTag = fromTag;
        this.orgFromTag = orgFromTag;
        this.toLinkTag = toLinkTag;
    }

    do(): boolean {
        this.xmlEntity.removeNode(this.toLinkTag);
        var transCollection = this.xmlEntity.ensureNode(WfConstants.NODE_TransitionCollection, this.fromTag);
        this.xmlEntity.addNode(this.toLinkTag, transCollection);
        return true;
    }

    undo(): void {
        this.xmlEntity.removeNode(this.toLinkTag);
        var transCollection = this.xmlEntity.ensureNode(WfConstants.NODE_TransitionCollection, this.orgFromTag);
        this.xmlEntity.addNode(this.toLinkTag, transCollection);
    }
}
