import ICmd from "../../../common/cmd/ICmd";
import GlobalConstants from "../../../common/struct/GlobalConstants";
import IXmlEntity from "../../../common/xml/IXmlEntity";
import ITagNode from "../../../common/xml/node/ITagNode";

export default class ChangeCaptionCmd implements ICmd {

    private tagNode: ITagNode;

    private xmlEntity: IXmlEntity;

    private oldCaption: string = "";

    private caption: string;

    constructor(xmlEntity: IXmlEntity, tagNode: ITagNode, caption: string) {
        this.xmlEntity = xmlEntity;
        this.tagNode = tagNode;
        this.caption = caption;
    }

    do(): boolean {
        this.oldCaption = this.tagNode.getAttributeValue(GlobalConstants.S_Caption);
        this.tagNode.setAttributeValue(GlobalConstants.S_Caption, this.caption);
        this.xmlEntity.update(this.tagNode, true);
        return true;
    }

    undo(): void {
        this.tagNode.setAttributeValue(GlobalConstants.S_Caption, this.oldCaption);
        this.xmlEntity.update(this.tagNode, true);
    }

}