export default class BPMN {

	public static PROPERTIES_XML_USER: string =
		`<BPMN>
	<DefineCollection>
		<!-- 流程属性: 标志、名称、版本、迁移表设置、忽略表单状态、查询撤销工作项信息、表单的反向模板定义、关闭实例触发器、驳回后是否锁定工作项、自定义流程图信息扩展类、自定义流程不同时机触发事件的扩展类 -->
		<!-- 未定义属性: 迁移表设置 -->
		<Define Key="Process" Caption="流程" Extends="">
			<PropertyCollection>
				<Property Key="Key" Caption="标志" Control="TextEditor" Editable="false" UpdateAttributeOnly="true"/>
				<Property Key="Version" Caption="版本" Control="NumberEditor" Editable="false" Visible="false" UpdateAttributeOnly="true"/>
				<Property Key="Caption" Caption="名称" Control="TextEditor" Editable="false" Visible="false" UpdateAttributeOnly="true"/>
				<Property Key="FormKey" Caption="绑定表单" Control="TempButtonEditor"  OnButtonClick="Macro_ShowWorkflowBindDialog()" Editable="true" UpdateAttributeOnly="true"/>
				<!--<Property Key="FormKey" Caption="权限表单" Control="Combobox" OnInitialize="=Macro_GetWorkflowFormKeyList()" Editable="true" UpdateAttributeOnly="true"/>-->
				<!--<Property Key="FormKey" Caption="权限表单" Control="YigoCodeDict" Editable="true" OnValueChanged="SetPara('PermFormKey', {{self.value}})" UpdateAttributeOnly="true"/>-->
				<!--<Property Key="FormKey" Caption="权限表单" Control="YigoDict" Editable="true"/>-->
				<Property Key="PermCollection|Perm" Type="Collection" Caption="权限设置" DefaultValue="=GetPermShowText()" DefaultValue="设置" Control="ButtonEditor" OnButtonClick="Macro_ShowPermDialog()" Editable="true" UpdateAttributeOnly="true"/>
			</PropertyCollection>
		</Define>
		
		<!-- 属性: 数字编号、标志、名称、默认图片、已通过状态图片、当前状态节点图片、自有节点状态、是否可以撤销工作项、撤销工作项通用名称、节点撤销事件、是否同步 -->
		<Define Key="Element" Caption="基础属性" Extends="">
			<PropertyCollection>
				<Property Key="Caption" Caption="名称" Control="TextEditor" Editable="true"/>
			</PropertyCollection>
		</Define>
		
		<!-- 流 -->
		<Define Key="Transition" Caption="流属性" Extends="Element">
			<PropertyCollection>
				<Property Key="TargetNodeKey" Caption="目标节点" Control="TextEditor" Editable="false"/>
			</PropertyCollection>
		</Define>
		<Define Key="Association" Caption="关联流" Extends="Transition"/>
		<Define Key="ExceptionFlow" Caption="异常流" Extends="Transition"/>
		<Define Key="SequenceFlow" Caption="顺序流" Extends="Transition">
			<PropertyCollection>
				<Property Key="Condition" Caption="条件值" Control="TempButtonEditor" OnButtonClick="Macro_ShowUserFormulaDialog('Condition', 'VALUE_CONDITION')" DefaultValue="true" Editable="true"/>
				<!--<Property Key="Status" Caption="状态" Control="Combobox" OnInitialize="=Macro_GetStatusList(GetWorkflowFormKey())" Editable="true"/>-->
			</PropertyCollection>
		</Define>
		
		<!-- 属性: 自有节点状态、是否可以撤销工作项、撤销工作项通用名称、节点撤销事件、是否同步、默认图片、已通过状态图片、当前状态节点图片 -->
		<!-- 未定义属性: RefType="New" -->
		<Define Key="Node" Caption="节点属性" Extends="Element">
			<PropertyCollection>
				<!--<Property Key="BPMState" Caption="自有节点状态" Control="NumberEditor" Editable="true"/>-->
			</PropertyCollection>
		</Define>

		<!-- 事件 -->
		<Define Key="Event" Extends="Node"/>	
		<!-- 属性: 开始事件 -->
		<Define Key="Begin" Caption="起始事件" Extends="Event">
			<PropertyCollection>
				<Property Key="Status" Caption="开始状态" Control="Combobox" OnInitialize="=Macro_GetStatusList(GetWorkflowFormKey())" Editable="true"/>
			</PropertyCollection>
		</Define>
		<!-- 属性: 状态标志、工作项创建事件、工作项完成事件、权限设置、绑定字段标志、绑定字段值、工作项撤销条件 -->
		<Define Key="State" Caption="状态节点" Extends="Event">
			<PropertyCollection>
				<Property Key="Status" Caption="状态标志" Control="Combobox" OnInitialize="=Macro_GetStatusList(GetWorkflowFormKey())"/>
				<Property Key="FieldKey" Caption="绑定字段" Control="Combobox" OnInitialize="=Macro_GetStatusFieldList(GetWorkflowFormKey())"/>
				<Property Key="FieldValue" Caption="绑定字段值" Control="Combobox" OnInitialize="=Macro_GetStatusValueList(GetWorkflowFormKey())"/>
				<Property Key="RevokeCondition" Caption="撤销条件" Control="ButtonEditor" OnButtonClick="Macro_ShowUserFormulaDialog('RevokeCondition', 'CONDITION')"/>
			</PropertyCollection>
		</Define>
		<!-- 属性: 分支结束事件 -->
		<Define Key="BranchEnd" Caption="分支结束" Extends="Event"/>
		<!-- 属性: 结束事件 -->
		<Define Key="End" Caption="结束事件" Extends="Event">
			<PropertyCollection>
				<Property Key="Status" Caption="结束状态" Control="Combobox" OnInitialize="=Macro_GetStatusList(GetWorkflowFormKey())" Editable="true"/>
			</PropertyCollection>
		</Define>
		
		<!-- 网关 -->
		<Define Key="BaseGateWay" Caption="网关" Extends="Node"/>
		<Define Key="Join" Caption="合并网关" Extends="BaseGateWay"/>
		<Define Key="Fork" Caption="分支网关" Extends="BaseGateWay"/>
		<Define Key="ExclusiveFork" Caption="互斥网关" Extends="BaseGateWay"/>
		<Define Key="ComplexJoin" Caption="复杂网关" Extends="BaseGateWay"/>
		<Define Key="Decision" Caption="选择网关" Extends="BaseGateWay">
			<PropertyCollection>
				<Property Key="Condition" Caption="选择条件" Control="TempButtonEditor" OnButtonClick="Macro_ShowUserFormulaDialog('Condition', 'VALUE_CONDITION')" Editable="true" Description="选择条件"/>
			</PropertyCollection>
		</Define>
		<Define Key="GateWay" Caption="路由网关" Extends="BaseGateWay">
			<PropertyCollection>
				<Property Key="Condition" Caption="流转条件" Control="ButtonEditor" OnButtonClick="Macro_ShowUserFormulaDialog('Condition', 'VALUE_CONDITION')" Editable="true" Description="流转条件"/>
			</PropertyCollection>
		</Define>
		
		<!-- 活动 -->
		<Define Key="Activity" Caption="工作项" Extends="Node"></Define>
		<Define Key="ManualTask" Caption="人工任务" Icon="&#xe923;" Extends="Activity"></Define>
		
		<Define Key="Task" Caption="任务" Extends="Activity">
			<PropertyCollection>
				<!-- 待处理 -->
				<Property Key="RevokeCondition" Caption="撤销条件" Control="ButtonEditor" OnButtonClick="Macro_ShowUserFormulaDialog('RevokeCondition', 'CONDITION')" Editable="true"/>
				<Property Key="CreateTrigger" Caption="工作项创建事件" Control="ButtonEditor" OnButtonClick="Macro_ShowUserFormulaDialog('CreateTrigger', 'ACTION')" Editable="true" Description=""/>
				<Property Key="FinishTrigger" Caption="工作项完成事件" Control="ButtonEditor" OnButtonClick="Macro_ShowUserFormulaDialog('FinishTrigger', 'ACTION')" Editable="true" Description=""/>
				<Property Key="AutoIgnoreNoParticipator" Caption="无参与者略过" Control="Combobox" OnInitialize="{list.boolean}" DefaultValue="false" Editable="true" Description="无参与者自动略过"/>
				<Property Key="AutoCommitContainSameParticipator" Caption="包含来源参与者自动提交" Control="Combobox" OnInitialize="{list.boolean}" DefaultValue="false" Editable="true" Description="包含上一参与者自动略过"/>
				<Property Key="AutoCommitSameParticipator" Caption="等于来源参与者自动提交" Control="Combobox" OnInitialize="{list.boolean}" DefaultValue="false" Editable="true" Description="等于上一参与者自动略过"/>
				<Property Key="ParticipatorCollection" Type="Collection" Caption="参与者集合" Control="ButtonEditor" OnButtonClick="Macro_ShowParticipatorCollectionDialog(GetSelectNodeXml('ParticipatorCollection'))" Editable="true" Visible="false" Description="参与者集合"/>
				<Property Key="OperationCollection" Type="Collection" Caption="操作集合"  DefaultValue="=GetCollectionShowText('OperationCollection')" Control="ButtonEditor" OnButtonClick="Macro_ShowOperationCollectionDialog(GetSelectNodeXml('OperationCollection'))" Editable="true" Description="操作集合" Visible="false"/>
			</PropertyCollection>
		</Define>
		
		<Define Key="ServiceTask" Caption="系统任务" Icon="&#xe609;" Extends="Activity">
			<PropertyCollection>
				<!-- 待处理 -->
				<Property Key="Action" Type="CDATA" Caption="操作" Control="ButtonEditor" OnButtonClick="Macro_ShowUserFormulaDialog('Action', 'ACTION')" Editable="true" Description=""/>
			</PropertyCollection>
		</Define>
		
		<Define Key="UserTask" Caption="用户任务" Icon="&#xe7f1;" Extends="Task"></Define>
		
		<Define Key="Audit" Caption="审批任务" Icon="&#xe656;" Extends="Task">
			<PropertyCollection>
				<Property Key="Perm" Type="Collection" Caption="权限设置" DefaultValue="=GetPermShowText()" DefaultValue="设置" Control="ButtonEditor" OnButtonClick="Macro_ShowPermDialog()" Editable="true" UpdateAttributeOnly="true"/>
				<Property Key="DenyToLastNode" Caption="是否驳回上一步" Control="Combobox" OnInitialize="{list.boolean}"  DefaultValue="false" Editable="true"/>
				<Property Key="DenyNodeKey" Caption="驳回目标节点" Control="Combobox" OnInitialize="=ListWorkflowNodes()" Visible="GetPropertyValue('DenyToLastNode', 'false')=='false'" Editable="true"/>
			</PropertyCollection>
		</Define>
		
		<Define Key="DataMap" Caption="映射任务" Icon="&#xe6bd;" Extends="Task">
			<PropertyCollection>
				<Property Key="MidDataMap" Caption="中间层映射" Control="Combobox" OnInitialize="{list.boolean}" Editable="false"/>
				<Property Key="SyncTriggerType" Caption="同步机制" Control="Combobox" OnInitialize="NoOpt,无操作;BillSave,数据保存;InstanceStart,实例启动;Async,实例结束" Editable="false"/>
				<Property Key="DataMapCondition" Caption="完成条件" Control="ButtonEditor" OnInitialize="{bpmn.input.formula}" Editable="false"/>
				<Property Key="BillDataMapInfoCollection" Type="Collection" Caption="映射集合" Control="ButtonEditor" OnInitialize="{bpmn.input.datamap.collection}" Editable="false"/>
			</PropertyCollection>
		</Define>
		
		<Define Key="Countersign" Caption="会签任务" Icon="&#xe6bd;" Extends="Task">
			<PropertyCollection>
				<Property Key="Perm" Type="Collection" Caption="权限设置" DefaultValue="=GetPermShowText()" DefaultValue="设置" Control="ButtonEditor" OnButtonClick="Macro_ShowPermDialog()" Editable="true" UpdateAttributeOnly="true"/>
				<Property Key="FinishType" Caption="完成类型" Control="Combobox" OnInitialize="{bpmn.countersign.condition.type}" Editable="true"/>
				<Property Key="FinishCondition" Caption="完成条件" Control="ButtonEditor" OnButtonClick="Macro_ShowUserFormulaDialog('FinishCondition', 'CONDITION')" Visible="GetPropertyValue('FinishType', 'None')=='Custom'" Editable="true"/>
				<Property Key="FinishCondition" Caption="完成条件" Control="TextEditor" Visible="GetPropertyValue('FinishType', 'None')=='Proportion'" Editable="true"/>		
				<Property Key="FinishCondition" Caption="完成条件" Control="NumberEditor" Visible="GetPropertyValue('FinishType', 'None')=='Number'" Editable="true"/>		
				<Property Key="FinishCondition" Caption="完成条件" Control="TextEditor" Visible="GetPropertyValue('FinishType', 'None')=='None'" Editable="false"/>
				<Property Key="ValidType" Caption="成立类型" Control="Combobox" OnInitialize="{bpmn.countersign.condition.type}" Editable="true"/>
				<Property Key="ValidCondition" Caption="成立条件" Control="ButtonEditor" OnButtonClick="Macro_ShowUserFormulaDialog('ValidCondition', 'CONDITION')" Visible="GetPropertyValue('ValidType', 'None')=='Custom'" Editable="true"/>
				<Property Key="ValidCondition" Caption="成立条件" Control="TextEditor" Visible="GetPropertyValue('ValidType', 'None')=='Proportion'" Editable="true"/>		
				<Property Key="ValidCondition" Caption="成立条件" Control="NumberEditor" Visible="GetPropertyValue('ValidType', 'None')=='Number'" Editable="true"/>		
				<Property Key="ValidCondition" Caption="成立条件" Control="TextEditor" Visible="GetPropertyValue('ValidType', 'None')=='None'" Editable="false"/>
				<Property Key="PassType" Caption="通过类型" Control="Combobox" OnInitialize="{bpmn.countersign.condition.type}" Editable="true"/>
				<Property Key="PassCondition" Caption="通过条件" Control="ButtonEditor" OnButtonClick="Macro_ShowUserFormulaDialog('PassCondition', 'CONDITION')" Visible="GetPropertyValue('PassType', 'None')=='Custom'" Editable="true"/>
				<Property Key="PassCondition" Caption="通过条件" Control="TextEditor" Visible="GetPropertyValue('PassType', 'None')=='Proportion'" Editable="true"/>		
				<Property Key="PassCondition" Caption="通过条件" Control="NumberEditor" Visible="GetPropertyValue('PassType', 'None')=='Number'" Editable="true"/>		
				<Property Key="PassCondition" Caption="通过条件" Control="TextEditor" Visible="GetPropertyValue('PassType', 'None')=='None'" Editable="false"/>
			</PropertyCollection>
		</Define>
		
		<Define Key="MultiUserTask" Caption="多人任务" Icon="&#xe61b;" Extends="UserTask">
			 <PropertyCollection>
				 <Property Key="InOrder" Caption="顺序执行" Control="Combobox" OnInitialize="{list.boolean}" Editable="false"/>
			</PropertyCollection>
		</Define>
		
		<Define Key="MultiAudit" Caption="多人审批" Icon="&#xe602;" Extends="Audit"></Define>
		
		<Define Key="StateAction" Caption="状态机" Icon="&#xe603;" Extends="Activity">
			<PropertyCollection>
				<Property Key="ParticipatorCollection" Type="Collection" Caption="参与者集合" Control="ButtonEditor" OnButtonClick="Macro_ShowParticipatorCollectionDialog(GetSelectNodeXml('ParticipatorCollection'))" Editable="false" Visible="false" Description="参与者集合"/>
				<Property Key="RevokeCondition" Caption="撤销条件" Control="ButtonEditor" OnInitialize="{bpmn.input.formula}" Editable="false"/>
				<Property Key="Key" Caption="操作标志" Control="TextEditor" Node="Operation" Group="公共操作" Editable="false"/>
				<Property Key="Operation" Type="Collection" Caption="操作"  DefaultValue="=GetCollectionShowText('Operation')" Control="ButtonEditor" OnButtonClick="Macro_ShowOperationDialog('<OperationCollection>' + IIF(GetSelectNodeXml('Operation') == '', '<Operation/>', GetSelectNodeXml('Operation')) + '</OperationCollection>')" Editable="true" Description="操作"/>

				<!-- <Property Key="Caption" Caption="操作名称" Control="TextEditor" Node="Operation" Group="公共操作" Editable="false"/>
				<Property Key="Enable" Caption="可用性" Control="ButtonEditor" Node="Operation" Group="公共操作" Editable="false"/>
				<Property Key="Visible" Caption="可见性" Control="ButtonEditor" Node="Operation" Group="公共操作" Editable="false"/>
				<Property Key="Icon" Caption="图标" Control="ButtonEditor" Node="Operation" OnInitialize="{input.image}" Group="公共操作" Editable="false"/>
				<Property Key="TemplateKey" Caption="模板标志" Control="TextEditor" Node="Operation" Group="公共操作" Editable="false"/>
				<Property Key="Action" Type="CDATA" Caption="行为" Control="ButtonEditor" OnButtonClick="{bpmn.input.formula}" Editable="false" Group="公共操作" Description=""/> -->
 			</PropertyCollection>
		</Define>
		
		<Define Key="SubProcess" Caption="子流程" Extends="Task">
			<PropertyCollection>
				<Property Key="SyncMode" Caption="执行顺序" Control="Combobox" DefaultValue="Sync" OnInitialize="Sync,同步;Async,异步" Editable="false"/>
				<Property Key="AutoStartAction" Caption="自动开始" Control="ButtonEditor" OnInitialize="{bpmn.input.formula}" Editable="false"/>
				<Property Key="SubProcessKey" Caption="子流程标志" Control="Combobox" OnInitialize="=Macro_GetWorkflowKeyList()" Editable="false"/>
			</PropertyCollection>
		</Define>
		
		<Define Key="Inline" Caption="内联流程" Extends="Activity">
			<PropertyCollection>
				<Property Key="InlineProcessKey" Caption="内联流程标志" Control="Combobox" OnInitialize="=Macro_GetWorkflowKeyList()" Editable="false"/>
			</PropertyCollection>
		</Define>
	</DefineCollection>
	</BPMN>`;


	public static PROPERTIES_XML_DEV: string =
		`<BPMN>
<DefineCollection>
	<!-- 流程属性: 标志、名称、版本、迁移表设置、忽略表单状态、查询撤销工作项信息、表单的反向模板定义、关闭实例触发器、驳回后是否锁定工作项、自定义流程图信息扩展类、自定义流程不同时机触发事件的扩展类 -->
	<!-- 未定义属性: 迁移表设置 -->
	<Define Key="Process" Caption="流程" Extends="">
		<PropertyCollection>
			<Property Key="Key" Caption="标志" Control="TextEditor" Editable="false"/>
			<Property Key="Version" Caption="版本" Control="NumberEditor" Editable="false" UpdateAttributeOnly="true"/>
			<Property Key="Caption" Caption="名称" Control="TextEditor" Editable="true"/>
			<Property Key="FormKey" Caption="绑定表单" Control="TempButtonEditor"  OnButtonClick="Macro_ShowWorkflowBindDialog()" Editable="true" UpdateAttributeOnly="true"/>
			<Property Key="PermCollection|Perm" Type="Collection" Caption="权限设置" DefaultValue="=GetPermShowText()" Control="ButtonEditor" OnButtonClick="Macro_ShowPermDialog()" Editable="true" UpdateAttributeOnly="true"/>
			<Property Key="DMTable" Type="Collection" Caption="迁移设置" DefaultValue="=GetCollectionShowText('DMTable')" Control="ButtonEditor" OnButtonClick="Macro_ShowDMTableDialog(GetDMTableXml())" Editable="true"/>
			<Property Key="IgnoreFormState" Caption="忽略表单状态" Control="Combobox" OnInitialize="{list.boolean}" DefaultValue="false" Description="忽略表单状态"/>
			<Property Key="QueryRetreatWorkitem" Caption="查询撤销工作项" Control="Combobox" OnInitialize="{list.boolean}" DefaultValue="true" Description="查询撤销工作项信息"/>
			<Property Key="TemplateKey" Caption="反向模板" Control="TextEditor" DefaultValue="" Editable="true" Description="表单的反向模板定义"/>
			<Property Key="KillInstanceTrigger" Caption="实例关闭触发" Control="TextEditor" DefaultValue="" Editable="true" Description="关闭实例触发器"/>	
			<Property Key="LockWorkitem" Caption="驳回锁定工作项" Control="Combobox" OnInitialize="True,是;False,否" DefaultValue="True" Description="驳回后是否锁定工作项"/>
			
			<Property Key="BPMGraphInfoPath" Node="Expand" Caption="流程图扩展类" Control="TextEditor" DefaultValue="" Description="自定义流程图信息扩展类" Group="扩展类"/>
			<Property Key="WorkFlowHookPath" Node="Expand" Caption="触发事件扩展类" Control="TextEditor" DefaultValue="" Description="自定义流程不同时机触发事件的扩展类" Group="扩展类"/>
		</PropertyCollection>
	</Define>
	
	<!-- 属性: 数字编号、标志、名称、默认图片、已通过状态图片、当前状态节点图片、自有节点状态、是否可以撤销工作项、撤销工作项通用名称、节点撤销事件、是否同步 -->
	<Define Key="Element" Caption="基础属性" Extends="">
		<PropertyCollection>
			<Property Key="ID" Caption="数字编号" Control="NumberEditor" Editable="false"/>
			<Property Key="Key" Caption="标志" Control="TextEditor" Editable="true"/>
			<Property Key="Caption" Caption="名称" Control="TextEditor" Editable="true"/>
		</PropertyCollection>
	</Define>
	
	<!-- 流 -->
	<Define Key="Transition" Caption="流属性" Extends="Element">
		<PropertyCollection>
			<Property Key="TargetNodeKey" Caption="目标节点" Control="TextEditor" Editable="false"/>
		</PropertyCollection>
	</Define>
	<Define Key="Association" Caption="关联流" Extends="Transition"/>
	<Define Key="ExceptionFlow" Caption="异常流" Extends="Transition"/>
	<Define Key="SequenceFlow" Caption="顺序流" Extends="Transition">
		<PropertyCollection>
			<Property Key="Status" Caption="状态" Control="Combobox" OnInitialize="=Macro_GetStatusList(GetWorkflowFormKey())" Editable="true"/>
			<Property Key="Condition" Caption="条件值" Control="TempButtonEditor" OnButtonClick="Macro_ShowFormulaDialog('{self.key}',{{self.value}})" DefaultValue = "true" Editable="true"/>
		</PropertyCollection>
	</Define>
	
	<!-- 属性: 自有节点状态、是否可以撤销工作项、撤销工作项通用名称、节点撤销事件、是否同步、默认图片、已通过状态图片、当前状态节点图片 -->
	<!-- 未定义属性: RefType="New" -->
	<Define Key="Node" Caption="节点属性" Extends="Element">
		<PropertyCollection>
			<Property Key="BPMState" Caption="自有节点状态" Control="NumberEditor" Editable="true"/>
			<Property Key="WorkitemRevoke" Caption="是否可撤销" Control="Combobox" OnInitialize="{list.boolean}" DefaultValue="true" Editable="true" Description="是否可以撤销工作项"/>
			<Property Key="RetreatCaption" Caption="撤销名称" Control="TextEditor" Editable="true" Description="撤销工作项通用名称"/>
			<Property Key="RevokeTrigger" Caption="撤销事件" Control="ButtonEditor" OnButtonClick="Macro_ShowFormulaDialog('{self.key}',{{self.value}})" Editable="true" Description="节点撤销事件"/>
			<Property Key="IsSync" Caption="是否同步" Control="Combobox" OnInitialize="{list.boolean}" DefaultValue="false" Editable="true"/>
			
			<!-- 待处理 -->
			<Property Key="Image" Caption="默认图片" Control="TextEditor" Node="NodeGraphic" Group="图形属性"/>
			<Property Key="LastImage" Caption="当前图片" Control="TextEditor" Node="NodeGraphic" Group="图形属性"/>
			<Property Key="PastImage" Caption="通过图片" Control="TextEditor" Node="NodeGraphic" Group="图形属性"/>
			
			<Property Key="X" Caption="X" Control="NumberEditor" Node="NodeGraphic" Visible="false" Group="图形属性" Editable="false"/>
			<Property Key="Y" Caption="Y" Control="NumberEditor" Node="NodeGraphic" Visible="false" Group="图形属性" Editable="false"/>
			<Property Key="Width" Caption="宽度" Control="NumberEditor" Node="NodeGraphic" Group="图形属性"/>
			<Property Key="Height" Caption="高度" Control="NumberEditor" Node="NodeGraphic" Group="图形属性"/>
		</PropertyCollection>
	</Define>
	
	
	<!-- 事件 -->
	<Define Key="Event" Extends="Node"/>	
	<!-- 属性: 开始事件 -->
	<Define Key="Begin" Caption="起始事件" Extends="Event">
		<PropertyCollection>
			<Property Key="Status" Caption="开始状态" Control="Combobox" OnInitialize="=Macro_GetStatusList(GetWorkflowFormKey())" Editable="true"/>
		</PropertyCollection>
	</Define>
	<!-- 属性: 状态标志、工作项创建事件、工作项完成事件、权限设置、绑定字段标志、绑定字段值、工作项撤销条件 -->
	<Define Key="State" Caption="状态节点" Extends="Event">
		<PropertyCollection>
			<Property Key="Status" Caption="状态标志" Control="Combobox" OnInitialize="=Macro_GetStatusList(GetWorkflowFormKey())"/>
			<Property Key="CreateTrigger" Caption="创建事件" Control="ButtonEditor" OnButtonClick="Macro_ShowFormulaDialog('{self.key}',{{self.value}})" Editable="true"/>
			<Property Key="FinishTrigger" Caption="完成事件" Control="ButtonEditor" OnButtonClick="Macro_ShowFormulaDialog('{self.key}',{{self.value}})" Editable="true"/>
			<Property Key="Perm" Type="Collection" Caption="权限设置" DefaultValue="=GetPermShowText()" Control="ButtonEditor" OnButtonClick="Macro_ShowPermDialog()" Editable="true" UpdateAttributeOnly="true"/>
			<Property Key="ParticipatorCollection" Type="Collection" Caption="参与者集合" DefaultValue="=GetCollectionShowText('ParticipatorCollection')" Control="ButtonEditor" OnButtonClick="Macro_ShowParticipatorCollectionDialog(GetSelectNodeXml('ParticipatorCollection'))" Editable="true" Description="参与者集合" Group="审批属性"  />
		    <Property Key="FieldKey" Caption="绑定字段" Control="Combobox" OnInitialize="=Macro_GetStatusFieldList(GetWorkflowFormKey())"/>
			<Property Key="FieldValue" Caption="绑定字段值" Control="Combobox" OnInitialize="=Macro_GetStatusValueList(GetWorkflowFormKey())"/>
			<Property Key="RevokeCondition" Caption="撤销条件" Control="ButtonEditor" OnButtonClick="Macro_ShowFormulaDialog('{self.key}',{{self.value}})" Editable="true"/>
		</PropertyCollection>
	</Define>
	<!-- 属性: 分支结束事件 -->
	<Define Key="BranchEnd" Caption="分支结束" Extends="Event"/>
	<!-- 属性: 结束事件 -->
	<Define Key="End" Caption="结束事件" Extends="Event">
		<PropertyCollection>
		<Property Key="Status" Caption="结束状态" Control="Combobox" OnInitialize="=Macro_GetStatusList(GetWorkflowFormKey())" Editable="true"/>
		</PropertyCollection>
	</Define>
	
	<!-- 网关 -->
	<Define Key="BaseGateWay" Caption="网关" Extends="Node"/>
	<Define Key="Join" Caption="合并网关" Extends="BaseGateWay"/>
	<Define Key="Fork" Caption="分支网关" Extends="BaseGateWay"/>
	<Define Key="ExclusiveFork" Caption="互斥网关" Extends="BaseGateWay"/>
	<Define Key="ComplexJoin" Caption="复合网关" Extends="BaseGateWay">
		<PropertyCollection>
			<Property Key="JoinCount" Caption="合并数量" Control="NumberEditor" DefaultValue="0" Group="复合网关"/>
			<Property Key="JoinCondition" Type="CDATA" Caption="合并条件" Control="ButtonEditor" OnButtonClick="Macro_ShowFormulaDialog('{self.key}',{{self.value}})" Editable="true" Group="复合网关" Description="合并条件"/>
		</PropertyCollection>
	</Define>
	<Define Key="Decision" Caption="选择网关" Extends="BaseGateWay">
		<PropertyCollection>
			<Property Key="Condition" Caption="选择条件" Control="TempButtonEditor" OnButtonClick="Macro_ShowFormulaDialog('{self.key}',{{self.value}})" Editable="true" Description="选择条件"/>
		</PropertyCollection>
	</Define>
	<Define Key="GateWay" Caption="路由网关" Extends="BaseGateWay">
		<PropertyCollection>
			<Property Key="Condition" Caption="流转条件" Control="ButtonEditor" OnButtonClick="Macro_ShowFormulaDialog('{self.key}',{{self.value}})" Editable="true" Description="流转条件"/>
		</PropertyCollection>
	</Define>
	
	<!-- 活动 -->
	<Define Key="Activity" Caption="工作项" Extends="Node"></Define>
	<Define Key="ManualTask" Caption="人工任务" Icon="&#xe923;" Extends="Activity"></Define>
	
	<Define Key="Task" Caption="任务" Extends="Activity">
		<PropertyCollection>
			<!-- 待处理 -->
			<Property Key="TimerItemCollection" Type="Collection" Caption="超时设置" DefaultValue="=GetCollectionShowText('TimerItemCollection')" Control="ButtonEditor" OnButtonClick="Macro_ShowTimerItemCollectionDialog(GetSelectNodeXml('TimerItemCollection'))" Editable="true" Description="用户超时集合"/>
			<Property Key="RevokeCondition" Caption="撤销条件" Control="ButtonEditor" OnButtonClick="Macro_ShowFormulaDialog('{self.key}',{{self.value}})" Editable="true"/>
			<Property Key="CreateTrigger" Caption="工作项创建事件" Control="ButtonEditor" OnButtonClick="Macro_ShowFormulaDialog('{self.key}',{{self.value}})" Editable="true" Description=""/>
			<Property Key="FinishTrigger" Caption="工作项完成事件" Control="ButtonEditor" OnButtonClick="Macro_ShowFormulaDialog('{self.key}',{{self.value}})" Editable="true" Description=""/>
			<Property Key="AutoIgnoreNoParticipator" Caption="无参与者略过" Control="Combobox" OnInitialize="{list.boolean}" DefaultValue="false" Editable="true" Description="无参与者自动略过"/>
			<Property Key="AutoCommitContainSameParticipator" Caption="包含来源参与者自动提交" Control="Combobox" OnInitialize="{list.boolean}" DefaultValue="false" Editable="true" Description="包含上一参与者自动略过"/>
			<Property Key="AutoCommitSameParticipator" Caption="等于来源参与者自动提交" Control="Combobox" OnInitialize="{list.boolean}" DefaultValue="false" Editable="true" Description="等于上一参与者自动略过"/>
			<Property Key="Perm" Type="Collection" Caption="权限设置" DefaultValue="=GetPermShowText()" Control="ButtonEditor" OnButtonClick="Macro_ShowPermDialog()" Editable="true" UpdateAttributeOnly="true"/>
			<Property Key="OperationCollection" Type="Collection" Caption="操作集合"  DefaultValue="=GetCollectionShowText('OperationCollection')" Control="ButtonEditor" OnButtonClick="Macro_ShowOperationCollectionDialog(GetSelectNodeXml('OperationCollection'))" Editable="true" Description="操作集合"/>
			<Property Key="AssistanceCollection" Type="Collection" Caption="辅助节点集合" DefaultValue="=GetCollectionShowText('AssistanceCollection')" Control="ButtonEditor" OnButtonClick="Macro_ShowAssistanceCollectionDialog(GetSelectNodeXml('AssistanceCollection'))" Editable="true" Description="辅助节点集合"/>
			<Property Key="ParticipatorCollection" Type="Collection" Caption="参与者集合" DefaultValue="=GetCollectionShowText('ParticipatorCollection')" Control="ButtonEditor" OnButtonClick="Macro_ShowParticipatorCollectionDialog(GetSelectNodeXml('ParticipatorCollection'))" Editable="true" Description="参与者集合"/>
		</PropertyCollection>
	</Define>
	
	<Define Key="ServiceTask" Caption="系统任务" Icon="&#xe609;" Extends="Node">
		<PropertyCollection>
			<!-- 待处理 -->
			<Property Key="Action" Type="CDATA" Caption="操作" Control="ButtonEditor" OnButtonClick="Macro_ShowFormulaDialog('{self.key}',{{self.value}})" Editable="true" Description=""/>
		</PropertyCollection>
	</Define>
	
	<Define Key="UserTask" Caption="用户任务" Icon="&#xe7f1;" Extends="Task"></Define>
	
	<Define Key="Audit" Caption="审批任务" Icon="&#xe656;" Extends="Task">
		<PropertyCollection>
			<Property Key="DenyToLastNode" Caption="是否驳回上一步" Control="Combobox" OnInitialize="{list.boolean}"  DefaultValue="false" Editable="true"/>
			<Property Key="DenyNodeKey" Caption="驳回目标节点" Control="Combobox" OnInitialize="=ListWorkflowNodes()" Visible="GetPropertyValue('DenyToLastNode', 'false')=='false'" Editable="true"/>
		</PropertyCollection>
	</Define>
	
    <Define Key="DataMap" Caption="映射任务" Icon="&#xe6bd;" Extends="Task">
    	<PropertyCollection>
    		<Property Key="MidDataMap" Caption="中间层映射" Control="Combobox" OnInitialize="{list.boolean}" DefaultValue="false" Editable="true"/>
    		<Property Key="SyncTriggerType" Caption="同步机制" Control="Combobox" OnInitialize="NoOpt,无操作;BillSave,数据保存;InstanceStart,实例启动;Async,实例结束" DefaultValue="NoOpt" Editable="true"/>
			<Property Key="DataMapCondition" Caption="完成条件" Control="ButtonEditor" OnButtonClick="Macro_ShowFormulaDialog('{self.key}',{{self.value}})" Editable="true"/>
			<Property Key="BillDataMapInfoCollection" Type="Collection" Caption="映射集合" DefaultValue="=GetCollectionShowText('BillDataMapInfoCollection')" Control="ButtonEditor" OnButtonClick="Macro_ShowBillDataMapInfoCollectionDialog(GetSelectNodeXml('BillDataMapInfoCollection'))" Editable="true"/>
		</PropertyCollection>
    </Define>
    
	<Define Key="Countersign" Caption="会签任务" Icon="&#xe6bd;" Extends="Task">
	<PropertyCollection>
		<Property Key="Perm" Type="Collection" Caption="权限设置" DefaultValue="=GetPermShowText()" DefaultValue="设置" Control="ButtonEditor" OnButtonClick="Macro_ShowPermDialog()" Editable="true" UpdateAttributeOnly="true"/>
		<Property Key="FinishType" Caption="完成类型" Control="Combobox" OnInitialize="{bpmn.countersign.condition.type}" Editable="true"/>
		<Property Key="FinishCondition" Caption="完成条件" Control="ButtonEditor" OnButtonClick="Macro_ShowFormulaDialog('{self.key}',{{self.value}})" Visible="GetPropertyValue('FinishType', 'None')=='Custom'" Editable="true"/>
		<Property Key="FinishCondition" Caption="完成条件" Control="TextEditor" Visible="GetPropertyValue('FinishType', 'None')=='Proportion'" Editable="true"/>		
		<Property Key="FinishCondition" Caption="完成条件" Control="NumberEditor" Visible="GetPropertyValue('FinishType', 'None')=='Number'" Editable="true"/>		
		<Property Key="FinishCondition" Caption="完成条件" Control="TextEditor" Visible="GetPropertyValue('FinishType', 'None')=='None'" Editable="false"/>
		<Property Key="ValidType" Caption="成立类型" Control="Combobox" OnInitialize="{bpmn.countersign.condition.type}" Editable="true"/>
		<Property Key="ValidCondition" Caption="成立条件" Control="ButtonEditor" OnButtonClick="Macro_ShowFormulaDialog('{self.key}',{{self.value}})" Visible="GetPropertyValue('ValidType', 'None')=='Custom'" Editable="true"/>
		<Property Key="ValidCondition" Caption="成立条件" Control="TextEditor" Visible="GetPropertyValue('ValidType', 'None')=='Proportion'" Editable="true"/>		
		<Property Key="ValidCondition" Caption="成立条件" Control="NumberEditor" Visible="GetPropertyValue('ValidType', 'None')=='Number'" Editable="true"/>		
		<Property Key="ValidCondition" Caption="成立条件" Control="TextEditor" Visible="GetPropertyValue('ValidType', 'None')=='None'" Editable="false"/>
		<Property Key="PassType" Caption="通过类型" Control="Combobox" OnInitialize="{bpmn.countersign.condition.type}" Editable="true"/>
		<Property Key="PassCondition" Caption="通过条件" Control="ButtonEditor" OnButtonClick="Macro_ShowFormulaDialog('{self.key}',{{self.value}})" Visible="GetPropertyValue('PassType', 'None')=='Custom'" Editable="true"/>
		<Property Key="PassCondition" Caption="通过条件" Control="TextEditor" Visible="GetPropertyValue('PassType', 'None')=='Proportion'" Editable="true"/>		
		<Property Key="PassCondition" Caption="通过条件" Control="NumberEditor" Visible="GetPropertyValue('PassType', 'None')=='Number'" Editable="true"/>		
		<Property Key="PassCondition" Caption="通过条件" Control="TextEditor" Visible="GetPropertyValue('PassType', 'None')=='None'" Editable="false"/>
	</PropertyCollection>
</Define>
	
	<Define Key="MultiUserTask" Caption="多人任务" Icon="&#xe61b;" Extends="UserTask">
		 <PropertyCollection>
		 	<Property Key="InOrder" Caption="顺序执行" Control="Combobox" OnInitialize="{list.boolean}" Editable="true"/>
		</PropertyCollection>
	</Define>
	
    <Define Key="MultiAudit" Caption="多人审批" Icon="&#xe602;" Extends="Audit"></Define>
    
	<Define Key="StateAction" Caption="状态机" Icon="&#xe603;" Extends="Activity">
		<PropertyCollection>
			<Property Key="ParticipatorCollection" Type="Collection" Caption="参与者集合" DefaultValue="=GetCollectionShowText('ParticipatorCollection')" Control="ButtonEditor" OnButtonClick="Macro_ShowParticipatorCollectionDialog(GetSelectNodeXml('ParticipatorCollection'))" Editable="true" Description="参与者集合"/>
			<Property Key="RevokeCondition" Caption="撤销条件" Control="ButtonEditor" OnButtonClick="Macro_ShowFormulaDialog('{self.key}',{{self.value}})" Editable="true"/>
			<Property Key="Operation" Type="Collection" Caption="操作"  DefaultValue="=GetCollectionShowText('Operation')" Control="ButtonEditor" OnButtonClick="Macro_ShowOperationDialog('<OperationCollection>' + IIF(GetSelectNodeXml('Operation') == '', '<Operation/>', GetSelectNodeXml('Operation')) + '</OperationCollection>')" Editable="true" Description="操作"/>

			<!--<Property Key="Key" Caption="操作标志" Control="TextEditor" Node="Operation" Group="公共操作" Editable="true"/>
			<Property Key="Caption" Caption="操作名称" Control="TextEditor" Node="Operation" Group="公共操作" Editable="true"/>
			<Property Key="Enable" Caption="可用性" Control="ButtonEditor" Node="Operation" OnButtonClick="Macro_ShowFormulaDialog('{self.key}',{{self.value}})" Group="公共操作" Editable="true"/>
			<Property Key="Visible" Caption="可见性" Control="ButtonEditor" Node="Operation" OnButtonClick="Macro_ShowFormulaDialog('{self.key}',{{self.value}})" Group="公共操作" Editable="true"/>
			<Property Key="Icon" Caption="图标" Control="ButtonEditor" Node="Operation" OnInitialize="{input.image}" Group="公共操作" Editable="true"/>
			<Property Key="TemplateKey" Caption="模板标志" Control="TextEditor" Node="Operation" Group="公共操作" Editable="true"/>
			<Property Key="Action" Type="CDATA" Caption="行为" Control="ButtonEditor" OnButtonClick="Macro_ShowFormulaDialog('{self.key}',{{self.value}})" Editable="true" Group="公共操作" Description=""/> -->
		</PropertyCollection>
	</Define>
	
	<Define Key="SubProcess" Caption="子流程" Extends="Task">
		<PropertyCollection>
			<Property Key="SyncMode" Caption="执行顺序" Control="Combobox" DefaultValue="Sync" OnInitialize="Sync,同步;Async,异步" Editable="true"/>
			<Property Key="AutoStartAction" Caption="自动开始" Control="ButtonEditor" OnButtonClick="Macro_ShowFormulaDialog('{self.key}',{{self.value}})" Editable="true"/>
			<Property Key="SubProcessKey" Caption="子流程标志" Control="Combobox" OnInitialize="=Macro_GetWorkflowKeyList()" Editable="true"/>
		</PropertyCollection>
	</Define>
	
	<Define Key="Inline" Caption="内联流程" Extends="Activity">
		<PropertyCollection>
			<Property Key="InlineProcessKey" Caption="内联流程标志" Control="Combobox" OnInitialize="=Macro_GetWorkflowKeyList()" Editable="true"/>
		</PropertyCollection>
	</Define>
</DefineCollection>
</BPMN>`;

}