import BorderPanel from "../../common/component/container/panel/BorderPanel";
import IEventListener from "../../common/listener/IEventListener";
import AbstractOptStateDelegate from "../../common/state/AbstractOptStateDelegate";
import Paras from "../../common/struct/Paras";
import { IDesignView } from "../../common/view/IDesignView";
import IXmlEntity from "../../common/xml/IXmlEntity";
import AbstractPropertyDefine from "../plugin/property/base/AbstractPropertyDefine";

export default abstract class AbstractGraphicView<T extends AbstractOptStateDelegate<any>> extends BorderPanel implements IDesignView, IEventListener {

    private bEditable: boolean = true;

    private optStateDelegate: T;

    constructor(left:number, right:number, top:number, bottom:number) {
        super(left, right, top, bottom);
        this.optStateDelegate = this.createOptStateDelegate();
    }

    setEditable(editable: boolean) {
        this.bEditable = editable;
    }

    isEditable() {
        return this.bEditable;
    }

    getOptStateDelegate(): T {
        return this.optStateDelegate;
    }

    abstract load(xmlEntity: IXmlEntity): void

    abstract createOptStateDelegate(): T;

    abstract notifyEvent(cmd: string, paras: Paras): void;

    abstract getPropertyDefine(): AbstractPropertyDefine;
}