import { ENodeType } from "../../enum/Enums";
import ContentNode from "./ContentNode";
import EmptyNode from "./EmptyNode";
import INode from "./INode";
import INodeFactory from "./INodeFactory";
import ITagNode from "./ITagNode";
import TagNode from "./TagNode";

export default class NodeFactoryWithoutComment implements INodeFactory {

	public createNode(type: ENodeType, content: string): INode {
		switch (type) {
            case ENodeType.COMMENT:
            case ENodeType.HEAD:
                return new EmptyNode();
			case ENodeType.CDATA:
			case ENodeType.TEXT:
				return new ContentNode(type, content);
			case ENodeType.TAG:
				return this.createTagNode(content) ;
			default:
				break;
			}
			throw new Error("unknow node type");
	}

	public createTagNode(tagName: string): ITagNode {
		return new TagNode(tagName);
	}

}
