import { ENodeType } from "../../enum/Enums";
import Var from "../../struct/Var";
import StringBuilder from "../../util/StringBuilder";
import IXmlNodeVisitor from "../IXmlNodeVisitor";
import INodeOutput from "../output/INodeOutput";
import INode from "./INode";
import ITagNode from "./ITagNode";

export default class EmptyNode implements INode {

	public constructor() {
	}

	resetLineIndex(varIndex: Var<number>): void {
	}
	
	getMaxNodeID(): number {
		return 0;
	}

	setParent(parent: ITagNode): void {
	}

	getParent(): ITagNode | undefined {
		return undefined;
	}

	findNodeByLine(line: number): INode | null{
		return null;
	}

	getStartLine(): number {
		return -1;
	}

	getEndLine(): number {
		return -1;
	}
	
	writeJSON(sb: StringBuilder): void {
	}
	
	setContent(content: string): void {
	}

	getNodeType(): ENodeType {
		return ENodeType.EMPTY;
	}

	public getContent(): string {
		return "";
	}

	public writeXml(level: number, sb: StringBuilder, bSimple: boolean): boolean {
		return true;
	}

	accept(visitor: IXmlNodeVisitor) {
	}

	outputLevel(level: number, outputHandler: INodeOutput): void {
	}
}
