import { ENodeType } from "../../enum/Enums";
import ContentNode from "./ContentNode";
import INode from "./INode";
import INodeFactory from "./INodeFactory";
import ITagNode from "./ITagNode";
import TagNode from "./TagNode";

export default class DefaultNodeFactory implements INodeFactory {

	public createNode(type: ENodeType, content: string): INode {
		switch (type) {
			case ENodeType.CDATA:
			case ENodeType.COMMENT:
			case ENodeType.TEXT:
			case ENodeType.HEAD:
				return new ContentNode(type, content);
			case ENodeType.TAG:
				return this.createTagNode(content) ;
			default:
				break;
			}
			throw new Error("unknow node type");
	}

	public createTagNode(tagName: string): ITagNode {
		return new TagNode(tagName);
	}

}
