import { ENodeType } from "../../enum/Enums";
import GlobalConstants from "../../struct/GlobalConstants";
import Var from "../../struct/Var";
import StringBuilder from "../../util/StringBuilder";
import IXmlNodeVisitor from "../IXmlNodeVisitor";
import INodeOutput from "../output/INodeOutput";
import XmlUtil from "../util/XmlUtil";
import INode from "./INode";
import ITagNode from "./ITagNode";
import VarIndexUtil from '../../util/VarIndexUtil';

export default class ContentNode implements INode {
	// 行号
	private line: number = -1;

	private nodeType: ENodeType;

	private content: string;

	private parent?: ITagNode;
	
	public constructor(nodeType: ENodeType, content: string) {
		this.nodeType = nodeType;
		this.content = content;
	}

	resetLineIndex(varIndex: Var<number>): void {
		this.line = VarIndexUtil.incVarIndex(varIndex);
	}
	
	getMaxNodeID(): number {
		return 0;
	}

	setParent(parent: ITagNode): void {
		this.parent = parent;
	}

	getParent(): ITagNode | undefined {
		return this.parent;
	}

	findNodeByLine(line: number): INode | null {
		if (line == this.line) {
			return this;
		}
		return null;
	}

	getEndLine(): number {
		return this.line;
	}

	getStartLine(): number {
		return this.line;
	}

	writeJSON(sb: StringBuilder): void {
		sb.append(GlobalConstants.S_ContentNode).append(this.content);
	}

	setContent(content: string): void {
		this.content = content;
	}

	getNodeType(): ENodeType {
		return this.nodeType;
	}

	public getContent(): string {
		return this.content;
	}

	public writeXml(level: number, sb: StringBuilder, bSimple: boolean): boolean {
		if (!bSimple) {
			XmlUtil.indentLine(level, sb);
		}
		sb.append(this.content);
		return true;
	}

	accept(visitor: IXmlNodeVisitor) {
		visitor.visit(this);
	}

	outputLevel(level: number, outputHandler: INodeOutput): void {
		outputHandler.out(level, this, true);
	}
}
