import XmlUtil from "../util/XmlUtil";
import IAttribute from "./IAttribute";

export default class Attribute implements IAttribute {
	
	private key: string = "";
	
	private value: string = "";

	constructor(key: string, value: string) {
		this.key = key;
		this.value = value;
	}

	public getKey(): string {
		return this.key;
	}
	
	public getValue(): string {
		return this.value;
	}

	setValue(value: string): void {
		value = XmlUtil.removeReturnChars(value);
		this.value = value;
	}

	toString(): string {
		var attrValue = XmlUtil.unescape(this.value);
		return `${this.key}="${attrValue}"`;
	}
	
}
