import { ETokenType } from "../enum/Enums";

export default class Token {
	
	public static TK_COMMENT_START: Token = new Token(ETokenType.COMMENT_START, "<!--");
	
	public static TK_EQ: Token = new Token(ETokenType.EQ, "=");
	
	public static TK_HEAD_START: Token = new Token(ETokenType.HEAD_START, "<?xml");
	
	public static TK_HEAD_END: Token = new Token(ETokenType.HEAD_END, "?>");
	
	public static TK_CDATA_START: Token = new Token(ETokenType.CDATA_START, "<![CDATA[");
	
	public static TK_LABS: Token = new Token(ETokenType.LABS, "</");
	
	public static TK_LAB: Token = new Token(ETokenType.LAB, "<");
	
	public static TK_SRAB: Token = new Token(ETokenType.SRAB, "/>");
	
	public static TK_RAB: Token = new Token(ETokenType.RAB, ">");

	public static TK_UNKNOW: Token = new Token(ETokenType.ERROR, "unknow");

	public static TK_END: Token = new Token(ETokenType.ERROR, "end");

	public static  CHAR_CMT_POSTFIX: string[] = ['-', '>']; //{, '>'};

	public static  CHAR_XML: string[] = ['x', 'm', 'l']; //{, '>'};

    private tokentype: ETokenType;
    
    private value: string;

	//private line: number;

	constructor(tokentype: ETokenType, value:string = "", line: number = -1) {
		this.tokentype = tokentype; 
        this.value = value;
	}

    public getType(): ETokenType {
    	return this.tokentype;
    }
    
    public getValue(): string {
    	return this.value;
    }

    public getTokenString(): string {
    	return "[" + this.tokentype + "," + this.value + "]";
    }
    
    public toString(): string {
    	return this.value;
    }
}