import { IPropertyPlugin } from "../../design/plugin/property/base/PropertyDefine";
import IXElement from "../dom/xelement/IXElement";
import IOperatioExecutor from "../operation/IOperatioExecutor";
import SelectionModel from "../selection/SelectionModel";
import IXmlEntity from "../xml/IXmlEntity";

export default interface IWorkSpace {

    /**
     * 重新根据视图重新生成源文件
     */
    reloadSource(): void;

    getXmlEntity(): IXmlEntity;

    getPropertyPlugin(): IPropertyPlugin;

    setDisplay(b: boolean): void;

    setEditable(b: boolean): void;

    doLayout(parent: HTMLElement): void;

    updateLayout(): void;

    load(xml: string): void;

    toXml(bSimple: boolean): string;

    getSelectionModel(): SelectionModel;

    setOperationExecutor(operatioExecutor: IOperatioExecutor): void;
}