

export default class TypeUtil {

    static toBoolean(value: any): boolean {
        if (value == undefined) return false;

        if (typeof(value) == 'string') {
            if ('true'.toLowerCase() == value) {
                return true;
            } else if ('false'.toLowerCase() == value) {
                return false;
            }
            return eval(value.toLowerCase());
        } else {
            return Boolean(value);
        }
    }

    static toNum(value: any): number {
        return Number(value);
    }

    public static isNum(obj: any): boolean {
        return typeof obj === 'number';
     }
 
     public static isStr(obj: any): boolean {
         return typeof obj === 'string';
     }

     public static isEmptyObject(obj: any) {
        if (obj == undefined || obj == null) return true;
        var name;
        for ( name in obj ) {
            return false;
        }
        return true;
    }

    static getReal(value: any, parentValue?: number): number | string {
        if (!TypeUtil.isDefined(value) || value == null || value <= 0)
            return 'auto';
        var real;
        if (TypeUtil.isNumeric(value) && value > 1) {
            real = value;
        } else if (TypeUtil.isNumeric(value) && value <= 1 && parentValue) {
            var percent = parseFloat(value);
            real = parentValue * percent;
        } else if (TypeUtil.isPercentage(value) && parentValue) {
            var percent = parseFloat(value) / 100;
            real = parentValue * percent;
        } else {
            real = parseInt(value, 10);
        }
        // IE中浮点数会有问题
        return Math.floor(real);
    }

    static isDefined(v: any): boolean {
        return  v != undefined;
    };

    static isPercentage(v: any): boolean {
        return v && /^(\d{1,2}%)$|^(100%)$/.test(v);
    }

    /**
     * 按jquery 3.1中的逻辑实现isNumeric方法
     * @param obj 
     * @returns 
     */
    static isNumeric(obj: any): boolean {
        if (TypeUtil.isNum(obj)) {
            return true;
        }
        if (TypeUtil.isStr(obj) && !isNaN(obj - parseFloat(obj))) {
            return true;
        }
        return false;
    };
    
}