
export default class MathUtil {

    public static offsetByTan(distance: number, tan: number, directX: number, directY: number): {offsetX: number, offsetY: number} {
        if (tan == Number.MAX_SAFE_INTEGER) {
            return {offsetX: 0, offsetY: distance * directY};
        }
        var sin = Math.sqrt(tan * tan / (1 + tan * tan));
        var cos = Math.sqrt(1 / (1 + tan * tan));
        var offset = {offsetX: distance * cos * directX , offsetY: distance * sin * directY};
        return offset;
    }

    public static tan(x1: number, y1: number, x2: number, y2: number): number {
        if (x1 == x2) return Number.MAX_SAFE_INTEGER;
        return (y2 - y1) / (x2 - x1);
    }

    public static isPercentage(v: any) {
        return v && /^(\d{1,2}%)$|^(100%)$/.test(v);
    }
}