import DomUtil from "../dom/DomUtil";
import AbstractOptStateDelegate from "./AbstractOptStateDelegate";
import IMouseState from "./IMouseState";

export default abstract class AbstractOptState<V, T extends AbstractOptStateDelegate<V>> implements IMouseState {

    protected leftMouseButtonDowning = false;

    protected delegate: T;
    
    constructor(delegate: T) {
        this.delegate = delegate;
        delegate.getView
    }

    getDelegate(): T {
        return this.delegate;
    }

    getView(): V {
        return this.delegate.getView();
    }

    reset(): void {
        this.delegate.reset();
    }

    dragstart(x: number, y: number, event: MouseEvent): void{}

    dragmove(dx: number, dy: number, x: number, y: number, event: MouseEvent): void{}

    dragend(event: MouseEvent): void{};

    isLeftMouseButtonDowning() {
        return this.leftMouseButtonDowning;
    }

    mousedown(e: MouseEvent): void {
        if(e.button == 0) {
            this.leftMouseButtonDowning = true;
        }
    };

    mouseup(e: MouseEvent): void {
        this.leftMouseButtonDowning = false;
    }

    protected getOffset(e: MouseEvent, beginX: number, beginY: number): {offsetX: number, offsetY: number}{
        var {x, y} = this.getPosition(e);
        var offsetX = x - beginX;
        var offsetY = y - beginY;
        return { offsetX, offsetY};
    }

    protected getPosition(e: MouseEvent): {x: number, y: number} {
        var {offsetBodyLeft, offsetBodyTop} = this.getOffsetFromBody();
        var {parentoffsetTop, parentOffsetLeft} = this.getScrollOffset(<HTMLElement> e.target, this.getViewEl());
        var x = e.clientX - offsetBodyLeft + parentOffsetLeft;
        var y = e.clientY - offsetBodyTop + parentoffsetTop;
        return {x: x, y: y}
    }

    getScrollOffset(fromEl: HTMLElement | null, toEl: HTMLElement): {parentoffsetTop: number, parentOffsetLeft: number} {
        if (!fromEl) {
            return {parentoffsetTop: 0, parentOffsetLeft: 0};
        }
        if (fromEl == toEl) {
            return {parentoffsetTop: fromEl.scrollTop, parentOffsetLeft: fromEl.scrollLeft}
        }
        var {parentoffsetTop, parentOffsetLeft} = this.getScrollOffset(fromEl.parentElement, toEl);
        var curOffsetTop = fromEl.scrollTop;
        var curOffsetLeft = fromEl.scrollLeft;
        return {parentoffsetTop: curOffsetTop + parentoffsetTop, parentOffsetLeft: curOffsetLeft + parentOffsetLeft};
    }

    private getOffsetFromBody(): {offsetBodyLeft: number, offsetBodyTop: number} {
        return DomUtil.offsetBodyPosition(this.getViewEl());
    }

    abstract mousemove(e: MouseEvent): void;

    abstract getViewEl(): HTMLElement;



}