import ArrayList from "../struct/ArrayList";
import IXmlEntity from "../xml/IXmlEntity";
import ITagNode from "../xml/node/ITagNode";
import ISelectable from "./ISelectable";

export default class SelectionModel {

    private bMultiSelection: boolean = false;

    private selectItems: ArrayList<ISelectable> = new ArrayList<ISelectable>();

    private xmlEntity: IXmlEntity;

    public constructor(xmlEntity: IXmlEntity) {
        this.xmlEntity = xmlEntity;
    }

    public reset() {
        this.xmlEntity.unSelectAll();
        this.selectItems.clearAll();
    }

    public setBMultiSelection(bMultiSelection: boolean): void {
        this.bMultiSelection = bMultiSelection
    }

    public getBMultiSelection(): boolean {
        return this.bMultiSelection
    }
    public unMultiSelection() {
        for (let i = 0; i < this.selectItems.getList().length; i++) {
            var item = this.selectItems.getList()[i];
            if (item) {
                this.xmlEntity.unselect(item);
            }
        }
        this.selectItems.clearAll();
    }
    public select(item: ISelectable | undefined | null) {
        if (!item) {
            this.reset();
        }
        if (!this.bMultiSelection) {
            this.reset();
        }
        item && this.selectItems.add(item);
        this.xmlEntity.select(item);
    }

    public selectRoot(): void {
        this.select(this.xmlEntity.getTagRoot());
    }

    public unselect(item: ISelectable): void {
        this.xmlEntity.unselect(item);
        this.selectItems.remove(item);
    }

    public hasSelected(item: ISelectable): boolean {
        return this.selectItems.contain(item);
    }

    public getSelectionItems(): ISelectable[] {
        return this.selectItems.getList();
    }

    public doCacheItems(): ISelectable[] {
        var items = [];
        for (let item of this.getSelectionItems()) {
            items.push(item);
        }
        return items;
    }

    public doCacheTagNodes4Node(): ITagNode[] {
        var items = [];
        for (let item of this.getSelectionItems()) {
            items.push(item.getTagNode());
        }
        return items;
    }

    public doCacheTagNodes(): ITagNode[] {
        var items = [];
        for (let item of this.getSelectionItems()) {
            items.push(item.getTagNode());
        }
        return items;
    }

    public getSingleSeletionItem(): ISelectable | undefined {
        if (this.selectItems.getSize() == 0) {
            return undefined;
        }
        return this.selectItems.get(0);
    }

    /*
    addSelectionChangedListener(listener: ISelectionChangedListener): void{
        this.listeners.add(listener);
    }

    fireSelectionChanged(item?: ISelectable): void {
        for (let listener of this.listeners.getList()) {
            listener.changeSelection(item);
        }
    }*/
}