import AbstractControl from "../component/control/AbstractControl";
import { EDesignMode } from "../enum/Enums";

/**
 * 操作执行者接口
 * 
 */
export default interface IOperatioExecutor {
    getForm(): any;
    
    create(): void;
    save(xml: string): void;
    load(xml: string): void;
    delete(): void;
    eval(exp: string): Promise<any>;
    asyncEval(exp: string): Promise<any>;

    createYigoControl(key: string, type: string, component: any):  AbstractControl<any>;

    getComponent(key: string): any;

    setEditable(b: boolean): void;
    isEditable(): boolean;

    queryFormulaDictID(code: string): Promise<number>;

    queryFormulaDictName(dictID: number): Promise<string>;

    queryDictID(dictKey: string, code: string): Promise<number>;

    isDevFormulaID(devFormulaID: number): boolean;

    getMode(): EDesignMode;

}