import AbstractControl from "../component/control/AbstractControl";
import TextEditor from "../component/control/TextEditor";
import { EDesignMode } from "../enum/Enums";
import IOperatioExecutor from "./IOperatioExecutor";

export default class BaseOperationExecutor implements IOperatioExecutor{


    constructor() {
    }

    getMode(): EDesignMode {
        return EDesignMode.Dev;
    }

    createYigoControl(key: string, type: string): AbstractControl<any> {
        return new TextEditor();
    }

    isDevFormulaID(devFormulaID: number): boolean {
        return true;
    }

    async queryFormulaDictID(code: string): Promise<number> {
        return -1;
    }

    async queryFormulaDictName(dictID: number): Promise<string> {
        return "";
    }

    async queryDictID(dictKey: string, code: string): Promise<number> {
        return -1;
    }

    setEditable(b: boolean): void {
    }

    isEditable(): boolean {
        return true;
    }
    
    getForm() { 
    }

    eval(exp: string): any {
        if ('true'.toLowerCase() == exp) {
            return true;
        }

        if ('false'.toLowerCase() == exp) {
            return false;
        }
    }

    asyncEval(exp: string): any{
        if ('true'.toLowerCase() == exp) {
            return true;
        }

        if ('false'.toLowerCase() == exp) {
            return false;
        }
    }

    getComponent(key: string): any {
    }

    create(): void {
        throw new Error("Method not implemented.");
    }

    save(): void {
        throw new Error("Method not implemented.");
    }

    load(xml: string): void {
        throw new Error("Method not implemented.");
    }

    delete(): void {
        throw new Error("Method not implemented.");
    } 
}
