export enum EDesignMode {
    /** 生产模式  */
    User = "User",
    /** 开发者模式 */
    Dev = "Dev",
    /** 本地模式 */
    Local = "Local"
}

export enum EViewModel {
    /** 设计模式 */
    Design = "Design",
    /** 源码模式 */
    Source = "Source",
    /** 上下混合模式 */
    MixV = "MixV",
    /** 左右混合模式 */
    MixH = "MixH"
}

export enum XMLElementType {
    CDATA = "CDATA",
    COLLECTION = "Collection",
    ATTRIBUTE = "Attribute"
}

export const enum EDesignType {
    BPMN = "bpmn",
    PRINT = "print"
}

export enum ESizeType {
    none = "none",
    px = "px",
    vh = "vh",
    mm = "mm",
    em = "em",
    Percent = "Percent",
    Auto = "auto",
    Pre = "Pre",
    Scale = "Scale",
    FlexScale = "FlexScale"
}

export enum ELayoutDirection {
    None = "",
    Row = "row",
    Column = "column"
}

export interface IAreaRange {
    getWidth: Function;
    getHeight: Function;
 }

export enum ENodeType {
    ROOT = 'root',
    HEAD = "head",
    COMMENT = "comment",
    CDATA = 'cdata',
    TAG = 'tag',
    TEXT = 'text',
    EMPTY = 'empty'
}

/**
 * 
 * LAB: 左箭括  <
 * LABS: 左箭括 加反斜杠</
 * HEAD_START: <?xml
 * HEAD_END: ?>
 * RAB: 右箭括  >
 * HEAD_END: ?> 
 * SRAB: 反斜杠加右箭括 />
 * CMT_START: 注释起始标志 <!--
 * CMT: 注释
 * CMT_END: 注释内容 + 注释结束标志 ... -->
 * CDA_START: CDATA起始标志
 * CDA_END: CDATA结束标志
 */
export enum ETokenType {
	LAB, LABS, HEAD_START, RAB, HEAD_END, SRAB, TEXT, STRING, EQ, COMMENT_START, COMMENT_END, CDATA_START, CDATA_END, ERROR
}

export enum EExtraLayoutType {
    Collapsible = 'Collapsible',
    Property = 'Property'
}

export enum ECollapseType {
    Row = 'Row',
    Cell = 'Cell'
}

export enum EHandleType {
    Custom = "Custom",
    Switch = "Switch",
    UpDown = "UpDown",
    SubAdd = "SubAdd"
}

export enum EHAlign {
    Left = 'Left',
    Center = 'Center',
    Right = 'Right'
}

export enum EVAlign {
    Top = 'Top',
    Center = 'Center',
    Bottom = 'Bottom'
}

export enum EUnderLineStyle {
    None = 'None',
    SolidNormal = 'SolidNormal',
    Dashed = 'Dashed',
    SolidBold = 'SolidBold'
}

export enum ETreeNodeType {
    Branch = 0,
    Leaf = 1
}

export enum EToggleStatus {
    Collapase = 0,
    Expand = 1
}


