export default interface IXElement {

    getHtmlClientHeight(): number;

    getHtmlClientWidth(): number;

    getHtmlOffsetWidth(): number;

    setInnerText(text: string): void;

    getInnerText(): string;

    getNodeType(): number;

    setAttribute(name: string, value: any): void;

    getAttribute(name: string): any;

    removeAttribute(name: string): void;

    setStyle(key: any, value: any): void;

    addClass(cls:string): void;

    removeClass(cls:string): void;

    toggleClass(cls:string): void;

    hasClass(cls:string): boolean;

    contains(child: IXElement): boolean;

    appendChild(child: IXElement): void;

    getChildren(): IXElement[];

    appendTo(parent: IXElement): void;

    removeChild(child: IXElement): void;

    addEventListener(name: string, fun: any, useCapture: boolean): void;

    removeEventListener(name: string, fun: any, useCapture: boolean): void;

    getHtmlElement(): HTMLElement;

    getImpl(): any;

    parentEl(): IXElement | null;

    blur(): void;

    focus(): void;

    click(): void;

    getScrollTop(): number;

    setScrollTop(top: number): void;

    getScrollLeft(): number;

    setScrollLeft(left: number): void;

    getOffsetLeft(): number;

    getOffsetTop(): number;

    setOncontextmenu(fn: any): void;

    getBoundingClientRect(): any;
}