import ToggleArrowLabel from "../../component/control/ToggleArrowLabel";
import AbstractDomElement from "../AbstractDomElement";

export default abstract class GroupElement extends AbstractDomElement {

    protected title: ToggleArrowLabel;

    protected caption: string;

    constructor(caption: string, expanded: boolean) {
        super();
        this.caption = caption;
        this.title = new ToggleArrowLabel(this.caption, expanded);

        this.title.addClass('property-title');
        this.title.addTextClass('property-title-caption');
        this.addChild(this.title);

        this.title.setToggleListener({toggle: (bExpanded) => {
            bExpanded ? this.displayGroup(): this.unDisplayGroup();
            this.resetHeight();
        }})
    }

    protected createEl(): HTMLElement {
        return document.createElement("ul");
    }

    isExpanded(): boolean {
        return this.title.isExpanded();
    }

    protected unDisplayGroup() {
        var tmpChildren = [];
        for(let child of this.getChildren()) {
            if (child != this.title) {
                tmpChildren.push(child);
            }
        }
        for(let child of tmpChildren) {
            this.removeChild(child);
        }
    }

    protected displayGroup(): void {};

    abstract resetHeight(): void;
}