import AbstractDomElement from "./AbstractDomElement";

export default class DomUtil { 

    private static parseEls(sHtml:string) {
        var objE = document.createElement("div");
        objE.innerHTML = sHtml.trim();
        return objE.childNodes; 
    }

    static parseEl(sHtml:string):HTMLElement {
        var els = this.parseEls(sHtml);
        return <HTMLElement> els[0];
    }
    
    static findParentElByTagName(el: HTMLElement, tagName: String): HTMLElement | null {
        var tmpEl: HTMLElement | null = el;
        while (tmpEl != null && tmpEl.tagName != "BODY") {
            if (tmpEl.tagName == tagName) {
                break;
            }
            tmpEl = tmpEl.parentElement;
        }
        return tmpEl;
    }

    static findParentElByClassName(el: HTMLElement, clsName: string): HTMLElement | null {
        var tmpEl: HTMLElement | null = el;
        while (tmpEl != null && tmpEl.tagName != "BODY") {
            if (tmpEl.classList.contains(clsName)) {
                break;
            }
            tmpEl = tmpEl.parentElement;
        }
        return tmpEl;
    }

    static isInDialog(el: HTMLElement): boolean {
        if (!el.parentElement) {
            return false;
        } else if (el.classList.contains('dialog') || el.classList.contains('CodeMirror-hints')) {
            return true;
        }
        return DomUtil.isInDialog(el.parentElement);
    }

    // 获取 当前 滚动条的长度， 水平 && 垂直方向
    static getScrollPosition(): {x: number, y: number}  {
        let x, y
        if (!!window.pageXOffset) {
            x = window.pageXOffset;
            y = window.pageYOffset;
        } else {
            x = (document.documentElement || document.body.parentNode || document.body).scrollLeft;
            y = (document.documentElement || document.body.parentNode || document.body).scrollTop;
        }
        return {x, y};
    }
 
    // 获取 dom 到视口左侧和顶部的相对位置
    static offsetViewPosition(el: HTMLElement): {offsetViewLeft: number, offsetViewTop: number} {
        let rect = el.getBoundingClientRect();
        return {
            offsetViewLeft: rect.left,
            offsetViewTop: rect.top
        };
    }

    // 相对于body的偏移量
    static offsetBodyPosition(el: HTMLElement): {offsetBodyLeft: number, offsetBodyTop: number} {
        let {x, y} = DomUtil.getScrollPosition(); // 获取滚动条长度
        let {offsetViewLeft, offsetViewTop} = DomUtil.offsetViewPosition(el); // 获取到视口的距离;
        return {
            offsetBodyLeft: offsetViewLeft + x,
            offsetBodyTop: offsetViewTop + y
        };
    }

    static offset(fromEl: HTMLElement, toEl: HTMLElement):  {offsetLeft: number, offsetTop: number} {
        let fromOffset = DomUtil.offsetBodyPosition(fromEl);
        let toOffset = DomUtil.offsetBodyPosition(toEl);

        return {
            offsetLeft: fromOffset.offsetBodyLeft - toOffset.offsetBodyLeft,
            offsetTop: fromOffset.offsetBodyTop - toOffset.offsetBodyTop
        }
    }

    static offsetParent(fromEl: HTMLElement):  {offsetLeft: number, offsetTop: number} {
        var parent = fromEl.parentElement ? fromEl.parentElement : document.body;
        return DomUtil.offset(fromEl, parent);
    }

        
    static queryElement(container: AbstractDomElement, el: HTMLElement | null): AbstractDomElement | null {
        if (container == null || el == null) return null;
        if (container.getEl() == el) {
            return container;
        }
        if (container.getChildren() != null) {
            var findResult: AbstractDomElement | null = null;
            for (let child of container.getChildren()) {
                findResult = DomUtil.queryElement(child, el);
                if (findResult != null) {
                    return findResult;
                }
            }
        }
        return null;
    }
}