import AbstractDomElement from "../../../../dom/AbstractDomElement";
import SpanElement from "../../../../dom/element/SpanElement";
import { ESizeType } from "../../../../enum/Enums";
import SizeInfo from "../../../../struct/SizeInfo";
import JTree from "../JTree";
import TreeItemModel from "../model/TreeItemModel";

/**
 * 树节点
 * 
 * @author chenbinbin
 */
export default class JTreeNode extends AbstractDomElement {

    private static WIDTH: number = 12;

    private static HEIGHT: number = 18;

    private spanIndent: SpanElement;

    private spanText: SpanElement;

    private toggleArrow!: SpanElement;

    private spanIcon!: SpanElement;

    constructor(item: TreeItemModel, tree: JTree) {
        super();
        this.addClass(tree.getTreeSkin().tree_item_node);
        this.spanIndent = new SpanElement();
        this.spanIndent.addClass("tree-indent");
        this.spanIndent.setStyleHeight(SizeInfo.valueOf(JTreeNode.HEIGHT, ESizeType.px));
        this.spanIndent.setStyleWidth(SizeInfo.valueOf(JTreeNode.WIDTH * item.getLevel(), ESizeType.px));

        if (!item.isLeaf()) {
            this.toggleArrow = new SpanElement();
            this.toggleArrow.addClass("iconfont");
            if (item.isExpand()) {
                this.markExpand();
            } else {
                this.markCollapse();
            }
        }

        if (item.getIconClass()) {
            this.spanIcon = new SpanElement();
            this.spanIcon.addClass("iconfont");
            this.spanIcon.addClass("hx-h5space");
            this.spanIcon.addClass(item.getIconClass());
        }
        this.spanText = new SpanElement(item.getCaption());
        this.addChild(this.spanIndent);
        this.addChild(this.toggleArrow);
        this.addChild(this.spanIcon);
        this.addChild(this.spanText);
    }

    markExpand(): void {
        this.toggleArrow.removeClass("icon-jiahaozhankai");
        this.toggleArrow.addClass("icon-jianhaoshouqi");
    }

    markCollapse(): void {
        this.toggleArrow.removeClass("icon-jianhaoshouqi");
        this.toggleArrow.addClass("icon-jiahaozhankai");
    }

}