import AbstractModel from "../../../../../common/model/AbstractModel";
import { ETreeNodeType } from "../../../../enum/Enums";
import { IItemData } from "../../../../struct/DataStruct";
import TreeItemModel from "./TreeItemModel";

/**
 * 树模型
 * 
 * @author chenbinbin
 */
export default class TreeModel extends AbstractModel {

    private root: TreeItemModel;

    private selectedItem: TreeItemModel | null = null;

    constructor() {
        super();
        this.root = new TreeItemModel({caption: "__ROOT__", data: null, branch: true}, "", this);
    }

    public getRoot(): TreeItemModel {
        return this.root;
    }

    public addItem(item: TreeItemModel) {
        this.root.addChild(item);
    }

    clear(): void {
        this.root.clearChildren();
    }

    public addChildItem(item: TreeItemModel, childItem: TreeItemModel) {
        if (item && childItem) {
            item.addChild(childItem);
        }
    }

    public setSelectedItem(item: TreeItemModel): void {
        if (this.selectedItem) {
            this.selectedItem.setSelect(false);
        }
        this.selectedItem = item;
        this.selectedItem.setSelect(true);
    }

    public createTreeItemModel(data: IItemData, clsIcon: string = ""): TreeItemModel {
        return new TreeItemModel(data, clsIcon, this, data.branch ? ETreeNodeType.Branch : ETreeNodeType.Leaf);
    }

}