import JComponent from "../../JComponent";
import JTreeItem from "./item/JTreeItem";
import JTreeItemGroup from "./item/JTreeItemGroup";
import TreeItemModel from "./model/TreeItemModel";
import TreeModel from "./model/TreeModel";

import AbstractTreeNode from "./node/AbstractTreeNode";
import DivElement from "../../../dom/element/DivElement";
import Events from "../../../event/Events";
import DomUtil from "../../../dom/DomUtil";
import EventHub from "../../../event/EventHub";
import { TreeSkin } from "../../../style/Skins";
import JTreeNode from "./node/JTreeNode";

/**
 * 树控件
 * 
 * @author chenbinbin
 */
export default class JTree extends JComponent<DivElement> {

    private model: TreeModel;

    private rootNode: JTreeItemGroup;

    protected emitter: EventHub<JTreeItem> = new EventHub();

    constructor(model: TreeModel) {
        super(new DivElement());
        this.addClass(this.getTreeSkin().tree);
        this.model = model;
        this.rootNode = new JTreeItemGroup(model.getRoot(), this);
        this.getDomElement().addChild(this.rootNode);
        this.rootNode.loadChildren();
        this.init();
    }

    protected init(): void {
        var self = this;
        this.addEventListener("click", function(e: any) {
            var el: HTMLElement | null =  DomUtil.findParentElByTagName(e.target, "LI");
            var node = DomUtil.queryElement(self.getDomElement(), el);
            if (node instanceof JTreeItem) {
                var treeItem: JTreeItem = <JTreeItem> node;
                self.model.setSelectedItem(treeItem.getModel());
                treeItem.getModel().setSelect(true);
                if (!treeItem.isLeaf()) {
                    treeItem.toggle();
                } else {
                    self.emitter.emit(Events.Tree.ITEM_CLICK, treeItem);
                }
            }
        }, true);

        this.addEventListener("dblclick", function(e: any) {
            var el: HTMLElement | null =  DomUtil.findParentElByTagName(e.target, "LI");
            var node = DomUtil.queryElement(self.getDomElement(), el);
            if (node instanceof JTreeItem) {
                var treeItem: JTreeItem = <JTreeItem> node;
                self.model.setSelectedItem(treeItem.getModel());
                treeItem.getModel().setSelect(true);
                if (!treeItem.isLeaf()) {
                    treeItem.toggle();
                } else {
                    self.emitter.emit(Events.Tree.ITEM_DBCLICK, treeItem);
                }
            }
        }, true);
    }

    getModel(): TreeModel {
        return this.model;
    }

    updateUI(): void {
        this.rootNode.unloadChildren();
        this.rootNode.loadChildren();
    }

    clearModel(): void {
        this.getModel().clear();
    }

    setOnItemClick(fn: any) {
        this.emitter.on(Events.Tree.ITEM_CLICK, fn);
    }

    setOnItemDoubleClick(fn: any) {
        this.emitter.on(Events.Tree.ITEM_DBCLICK, fn);
    }

    createNodeView(itemModel: TreeItemModel): AbstractTreeNode {
        return new JTreeNode(itemModel, this);
    }

    getTreeSkin(): TreeSkin {
        return this.styleFactory.getTreeSkin();
    }
}