import DivElement from "../../dom/element/DivElement";
import SizeInfo from "../../struct/SizeInfo";
import JComponent from "../JComponent";

export default class ToolFontItem extends JComponent<DivElement>  {

    private static ITEM_HEIGHT: number = 46;

    constructor(key: string, option:{cls: string[]}) {
        super(new DivElement());
        this.setKey(key);
        this.getEl().setAttribute("id", key);
        this.getEl().setAttribute("draggable", "true");
        this.setHeight(SizeInfo.valueOfPX(ToolFontItem.ITEM_HEIGHT))
        for (let c of option.cls) {
            this.addClass(c);
        }
    }
}