import DivElement from "../../dom/element/DivElement";
import LiElement from "../../dom/element/LiElement";
import SpanElement from "../../dom/element/SpanElement";
import UlElement from "../../dom/element/UlElement";
import GlobalSetting from "../../GlobalSetting";
import ArrayList from "../../struct/ArrayList";
import SizeInfo from "../../struct/SizeInfo";
import JComponent from "../JComponent";

export default class Toolbar extends JComponent<DivElement> {

    private items: ArrayList<JComponent<any>> = new ArrayList<JComponent<any>>();

    private ulElement: UlElement;

    constructor(height: number = GlobalSetting.D_TOOLBAR_HEIGHT) {
        super(new DivElement());
        this.setHeight(SizeInfo.valueOfPX(height));
        this.ulElement = new UlElement();
        this.getDomElement().addChild(this.ulElement);
        this.addClassArray(this.styleFactory.getToolbar());

        this.setStyle("overflow", "auto");
    }

    addItem(item: JComponent<any>): void {
        var liElement = new LiElement();
        this.ulElement.addChild(liElement);
        liElement.addChild(item.getDomElement())
        this.items.add(item);
    }

    public addSeparator(): void {
        var liElement = new LiElement();
        this.ulElement.addChild(liElement);
        var span = new SpanElement();
        span.addClassArray(this.styleFactory.getToolbarSeparator());
        liElement.addChild(span);
        this.ulElement.addChild(liElement);
    }
}
