import SizeInfo from "../../../struct/SizeInfo";
import DivElement from "../../../dom/element/DivElement";
import JComponent from "../../JComponent";
import JTableArea from "../area/JTableArea";
import JTableBodyRow from "../base/body/JTableBodyRow";
import ColumnConfig from "../base/column/ColumnConfig";

export default class JGrid extends JComponent<DivElement> { 
 
    private tableArea: JTableArea;

    //private pageArea: JTablePageArea;
    
    constructor(key: string) {
        super(new DivElement());
        this.tableArea = new JTableArea();
       // this.pageArea = new JTablePageArea();
        this.getDomElement().addChild(this.tableArea);
        this.initSkin();
    }

    private initSkin() {
        var skin = this.styleFactory.getTableSkin();
        this.addClass(skin.table_view);
    }

    addColumn(key: string, caption?: string): ColumnConfig {
        return this.tableArea.addColumn(key, caption);
    }

    addRow(): JTableBodyRow {
        return this.tableArea.addRow();
    }

    setCellValue(row: number, col: number, value: any): void {
       this.tableArea.setBodyCellValue(row, col, value);
    }

    setHeight(height: SizeInfo): void {
        super.setHeight(height);
        if (SizeInfo.isFixSize(height)) {
            this.tableArea.setHeight(height.getValue());
        }
    }

    display(): void {
        this.tableArea.display(this.getDomElement());
    }
}

/** 
`
<div class="layui-form layui-border-box layui-table-view" lay-filter="LAY-table-1" lay-id="test" style=" ">
    <div class="layui-table-box">
        <div class="layui-table-header">
            <table cellspacing="0" cellpadding="0" border="0" class="layui-table">
                <thead>
                    <tr>
                        <th data-field="id" data-key="1-0-0" class=" layui-unselect">
                            <div class="layui-table-cell laytable-cell-1-0-0">
                                <span>ID</span>
                                <span class="layui-table-sort layui-inline">
                                    <i class="layui-edge layui-table-sort-asc" title="升序"></i>
                                    <i class="layui-edge layui-table-sort-desc" title="降序"></i>
                                </span>
                            </div>
                        </th>
                        <th data-field="username" data-key="1-0-1" class="">
                            <div class="layui-table-cell laytable-cell-1-0-1">
                                <span>用户名</span>
                            </div>
                        </th>
                        <th data-field="sex" data-key="1-0-2" class=" layui-unselect">
                            <div class="layui-table-cell laytable-cell-1-0-2">
                                <span>性别</span>
                                <span class="layui-table-sort layui-inline">
                                    <i class="layui-edge layui-table-sort-asc" title="升序"></i>
                                    <i class="layui-edge layui-table-sort-desc" title="降序"></i>
                                </span>
                            </div>
                        </th>
                        <th data-field="city" data-key="1-0-3" class="">
                            <div class="layui-table-cell laytable-cell-1-0-3">
                                <span>城市</span>
                            </div>
                        </th>
                        <th data-field="sign" data-key="1-0-4" data-minwidth="150" class="">
                            <div class="layui-table-cell laytable-cell-1-0-4">
                                <span>签名</span>
                            </div>
                        /th>
                        <th data-field="experience" data-key="1-0-5" class=" layui-unselect">
                            <div class="layui-table-cell laytable-cell-1-0-5">
                                <span>积分</span>
                                <span class="layui-table-sort layui-inline">
                                    <i class="layui-edge layui-table-sort-asc" title="升序"></i>
                                    <i class="layui-edge layui-table-sort-desc" title="降序"></i>
                                </span>
                            </div>
                        </th>
                        <th data-field="score" data-key="1-0-6" class=" layui-unselect">
                            <div class="layui-table-cell laytable-cell-1-0-6">
                                <span>评分</span>
                                <span class="layui-table-sort layui-inline">
                                    <i class="layui-edge layui-table-sort-asc" title="升序"></i>
                                    <i class="layui-edge layui-table-sort-desc" title="降序"></i>
                                </span>
                            </div>
                        </th>
                        <th data-field="classify" data-key="1-0-7" class="">
                            <div class="layui-table-cell laytable-cell-1-0-7">
                                <span>职业</span>
                            </div>
                        </th>
                        <th data-field="wealth" data-key="1-0-8" class=" layui-unselect">
                            <div class="layui-table-cell laytable-cell-1-0-8">
                                <span>财富</span>
                                <span class="layui-table-sort layui-inline">
                                    <i class="layui-edge layui-table-sort-asc" title="升序"></i>
                                    <i class="layui-edge layui-table-sort-desc" title="降序"></i>
                                </span>
                            </div>
                        </th>
                    </tr>
                </thead>
            </table>
        </div>
        <div class="layui-table-body layui-table-main">
            <table cellspacing="0" cellpadding="0" border="0" class="layui-table">
                <tbody>
                    <tr data-index="0">
                        <td data-field="id" data-key="1-0-0" class="">
                            <div class="layui-table-cell laytable-cell-1-0-0">10000</div>
                        </td>
                        <td data-field="username" data-key="1-0-1" class="">
                            <div class="layui-table-cell laytable-cell-1-0-1">user-0</div>
                        </td>
                        <td data-field="sex" data-key="1-0-2" class="">
                            <div class="layui-table-cell laytable-cell-1-0-2">女</div>
                        </td>
                        <td data-field="city" data-key="1-0-3" class="">
                            <div class="layui-table-cell laytable-cell-1-0-3">城市-0</div>
                        </td>
                        <td data-field="sign" data-key="1-0-4" data-minwidth="150" class="">
                            <div class="layui-table-cell laytable-cell-1-0-4">签名-0</div>
                        </td>
                        <td data-field="experience" data-key="1-0-5" class="">
                            <div class="layui-table-cell laytable-cell-1-0-5">255</div>
                        </td>
                        <td data-field="score" data-key="1-0-6" class="">
                            <div class="layui-table-cell laytable-cell-1-0-6">57</div>
                        </td>
                        <td data-field="classify" data-key="1-0-7" class="">
                            <div class="layui-table-cell laytable-cell-1-0-7">作家</div>
                        </td>
                        <td data-field="wealth" data-key="1-0-8" class="">
                            <div class="layui-table-cell laytable-cell-1-0-8">82830700</div>
                        </td>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>
    <div class="layui-table-page">
        <div id="layui-table-page1">
            <div class="layui-box layui-laypage layui-laypage-default" id="layui-laypage-1">
                <a href="javascript:;" class="layui-laypage-prev layui-disabled" data-page="0">
                    <i class="layui-icon"></i>
                </a>
                <span class="layui-laypage-curr">
                    <em class="layui-laypage-em"></em>
                    <em>1</em>
                </span>
                <a href="javascript:;" data-page="2">2</a>
                <a href="javascript:;" data-page="3">3</a>
                <span class="layui-laypage-spr">…</span>
                <a href="javascript:;" class="layui-laypage-last" title="尾页" data-page="100">100</a>
                <a href="javascript:;" class="layui-laypage-next" data-page="2">
                    <i class="layui-icon"></i>
                </a>
                <span class="layui-laypage-skip">到第<input type="text" min="1" value="1" class="layui-input">页
                    <button type="button" class="layui-laypage-btn">确定</button>
                </span>
                <span class="layui-laypage-count">共 1000 条</span>
                <span class="layui-laypage-limits">
                    <select lay-ignore="">
                        <option value="10" selected="">10 条/页</option>
                        <option value="20">20 条/页</option>
                        <option value="30">30 条/页</option>
                        <option value="40">40 条/页</option>
                        <option value="50">50 条/页</option>
                        <option value="60">60 条/页</option>
                        <option value="70">70 条/页</option>
                        <option value="80">80 条/页</option>
                        <option value="90">90 条/页</option>
                    </select>
                </span>
            </div>
        </div>
    </div>
    <style>
        .laytable-cell-1-0-0{ width: 80px; }
        .laytable-cell-1-0-1{ width: 80px; }
        .laytable-cell-1-0-2{ width: 80px; }
        .laytable-cell-1-0-3{ width: 80px; }
        .laytable-cell-1-0-4{  }
        .laytable-cell-1-0-5{ width: 80px; }
        .laytable-cell-1-0-6{ width: 80px; }
        .laytable-cell-1-0-7{ width: 80px; }
        .laytable-cell-1-0-8{ width: 135px; }
    </style>
</div>

`
*/