import SizeInfo from "../../../../struct/SizeInfo";
import AbstractDomElement from "../../../../dom/AbstractDomElement";
import { ESizeType } from "../../../../enum/Enums";
import JTableCol from "./JTableCol";

export default class JTableColGroup extends AbstractDomElement {

    protected createEl(tag:string): HTMLElement {
        return document.createElement('colgroup');
    }

    public addCol(width: SizeInfo = SizeInfo.valueOf(120, ESizeType.px)): JTableCol {
        var col  = new JTableCol();
        this.addChild(col);
        col.setWidth(width);
        return col;
    }

} 