import TypeUtil from "../../../../util/TypeUtil";
import JTableRow from "../JTableRow";
import JTableDataCell from "./JTableBodyCell";

export default class JTableBodyRow extends JTableRow<JTableDataCell> {

    private setCellTextByIndex(index: number, text: string): void {
        var cell = this.getCell(index);
        if (cell != null) {
            cell.setText(text);
        }
    }

    private setCellTextByKey(key: string, text: string): void {
        
    }

    setCellText(key: string | number, text: string): void {
        TypeUtil.isNum(key) ? this.setCellTextByIndex(<number> key, text) 
                : this.setCellTextByKey(<string> key, text);
    }
}