import SizeInfo from "../../../struct/SizeInfo";
import AbstractDomElement from "../../../dom/AbstractDomElement";

export default class JTableRow<T extends AbstractDomElement> extends AbstractDomElement {
    
    constructor() {
        super();
    }

    protected createEl(tag:string): HTMLElement {
        return document.createElement('tr');
    }

    getCell(index: number): T | null {
        return <T> this.getChildAt(index);
    }

    addCell(cell: T) {
        this.addChild(cell);
    }

    removeCell(cell: T) {
        this.removeChild(cell);
    }

    setHeight(height: SizeInfo): void {
        this.setStyleHeight(height);
    }
}