import SizeInfo from "../../../struct/SizeInfo";
import TableElement from "../../../dom/element/TableElement";
import { ESizeType } from "../../../enum/Enums";
import JComponent from "../../JComponent";
import JTableBody from "./body/JTableBody";
import JTableBodyRow from "./body/JTableBodyRow";
import JTableCol from "./column/JTableCol";
import JTableColGroup from "./column/JTableColGroup";
import JTableFoot from "./foot/JTableFoot";
import JTableHead from "./head/JTableHead";
import JTableHeadRow from "./head/JTableHeadRow";

export default class JTable extends JComponent<TableElement> {

    private tableColGroup: JTableColGroup;

    private tableHead: JTableHead  | null = null;

    private tableBody: JTableBody  | null = null;

    private tableFoot: JTableFoot | null = null;

    private dataRowHeight: SizeInfo = SizeInfo.valueOf(40, ESizeType.px);

    constructor(key: string) {
        super(new TableElement());
        this.tableColGroup = new JTableColGroup();
        this.getDomElement().addChild(this.tableColGroup);
        this.initSkin();
    }
  
    private initSkin() {
        var skin = this.styleFactory.getTableSkin();
        this.addClass(skin.table);
    }

    protected createEl(tag:string): HTMLElement {
        return document.createElement('table');
    }

    addCol(width: SizeInfo): JTableCol {
        if (this.getDomElement().hasChild(this.tableColGroup)) {

        }
        return this.tableColGroup.addCol(width);
    }

    addHeadRow(): JTableHeadRow {
        if (this.tableHead == null) {
            this.tableHead = new JTableHead();
            this.getDomElement().addChild(this.tableHead)
        }
        var row = this.tableHead.addRow();
        return row;
    }

    clearHeadRow(): void {
        if (this.tableHead == null) {
            return;
        }
        this.tableHead.clearAllRow()
    }

    addBodyRow(): JTableBodyRow {
        this.tableBody = this.ensureTableBody()
        var row = this.tableBody.addRow();
        row.setHeight(this.dataRowHeight);
        return row;
    }

    addFootRow(): JTableBodyRow {
        if (this.tableFoot == null) {
            this.tableFoot = new JTableFoot();
            this.getDomElement().addChild(this.tableFoot)
        }
        var row = this.tableFoot.addRow();
        return row;
    }

    setBodyCellValue(row: number, col: number, value: string): void {
        this.tableBody = this.ensureTableBody()
        var tableRow = this.tableBody.getRow(row);
        tableRow && tableRow.setCellText(col, value);
    }

    private ensureTableBody(): JTableBody {
        if (this.tableBody == null) {
            this.tableBody = new JTableBody();
            this.getDomElement().addChild(this.tableBody)
        }
        return this.tableBody;
    }
}