import { ECollapseType, EHandleType } from "../../enum/Enums";
import GlobalConstants from "../../struct/GlobalConstants";
import Collapse from "../control/Collapse";
import { EComponentType } from "../EComponentType";

/**
 * 收缩控制点控件创建
 */
export default class CollapseHandleFactory {
    public static create(type: string, bExpand: boolean, caption: string = "",
        clsExpand?: string, clsCollapse?: string): Collapse {
        switch (type) {
            case EHandleType.Switch:
                return new Collapse(caption, bExpand, GlobalConstants.ICON_SWICH_ON, GlobalConstants.ICON_SWICH_OFF);
            case EHandleType.UpDown:
                return new Collapse(caption, bExpand, GlobalConstants.ICON_COLLAPSE_ARROWDOWN, GlobalConstants.ICON_COLLAPSE_ARROWUP);
            case EHandleType.SubAdd:
                return new Collapse(caption, bExpand);
            case EHandleType.Custom:
                return new Collapse(caption, bExpand, clsExpand, clsCollapse);
        }
        throw new Error("Unsupport boolean collapse handle type:" + type);
    }
}