
import AbstractDomElement from "../../dom/AbstractDomElement";
import SpanIcon from "../../dom/element/SpanIcon";
import { IToggleListener } from "../../dom/listener/Listeners";
import Label from "./Label";

export default class ToggleArrowLabel extends AbstractDomElement {

    public static DEFAULT_EXPAND_ICON: string = 'icon-jiahaozhankai';

    public static DEFAULT_COLLAPSE_ICON: string = 'icon-jianhaoshouqi';

    private toggleArrow: SpanIcon = new SpanIcon('iconfont');

    private spanText: Label;

    private expanded: boolean;

    private toggleListener?: IToggleListener;

    private clsExpandIcon: string;

    private clsCollapseIcon: string;

    constructor(caption: string, expanded: boolean, 
        clsExpandIcon: string = ToggleArrowLabel.DEFAULT_EXPAND_ICON, clsCollapseIcon: string = ToggleArrowLabel.DEFAULT_COLLAPSE_ICON) {
        super();
        this.expanded = expanded;
        this.clsExpandIcon = clsExpandIcon;
        this.clsCollapseIcon = clsCollapseIcon;
        this.spanText = new Label(caption);
        this.addChild(this.toggleArrow);
        this.addChild(this.spanText.getDomElement());
        this.updateUI();

        var self = this;
        this.toggleArrow.addEventListener("click", function(e: any) {
            self.toggle();
        }, true);
    }

    initExpandAndCollapseIcon(clsExpandIcon: string, clsCollapseIcon: string): void {
        this.clsExpandIcon = clsExpandIcon;
        this.clsCollapseIcon = clsCollapseIcon;
    }

    setText(text: string): void {
        this.spanText.setValue(text);
    }

    addTextClass(clsText: string): void {
        this.spanText.addClass(clsText);
    }

    setToggleListener(toggleListener: IToggleListener) {
        this.toggleListener = toggleListener;
    }

    isExpanded(): boolean {
        return this.expanded;
    }

    toggle(): void {
        this.expanded = !this.expanded;
        this.toggleListener && this.toggleListener.toggle(this.expanded);
        this.updateUI();
    }

    expand(): void {
        this.expanded = true;
        this.toggleArrow.removeClass(this.clsExpandIcon);
        this.toggleArrow.addClass(this.clsCollapseIcon);
    }

    collapse(): void {
        this.expanded = false;
        this.toggleArrow.removeClass(this.clsCollapseIcon);
        this.toggleArrow.addClass(this.clsExpandIcon);
    }

    setTextStyle(name: string, value: string) {
        this.spanText.setStyle(name, value);
    }

    private updateUI(): void {
        this.expanded ? this.expand(): this.collapse();
    }
}
