import ButtonElement from "../../dom/element/ButtonElement";
import IconElement from "../../dom/element/IconElement";
import AbstractControl from "./AbstractControl";

export default class IconButton extends AbstractControl<ButtonElement> {

    constructor(cls: string) {
        super(new ButtonElement());
        this.addClass("yg_button");
        var icon = new IconElement();
        icon.addClass(cls);
        this.getDomElement().addChild(icon);
    }

    setOnClickListener(fun: any): void {
        this.getDomElement().addEventListener("click", fun, false);
    }
}