import { IComboboxData } from "../../struct/DataStruct";
import SelectElement from "../../dom/element/SelectElement";
import TypeUtil from "../../util/TypeUtil";
import AbstractControl from "./AbstractControl";

export default class Combobox extends AbstractControl<SelectElement> {

    private items?: IComboboxData[];

    constructor() {
        super(new SelectElement());
    }

    initControl(initialValue: any) {
        if (initialValue instanceof Array) {
            this.items = <IComboboxData[]> initialValue;
        } else if (initialValue instanceof Function) {
            this.items = <IComboboxData[]> initialValue();
        } else if (TypeUtil.isStr(initialValue)) {
            var strInitialValue = <string> initialValue;
            this.items = this.createItems(strInitialValue);
        }
        if (this.items) {
            for (let item of this.items) {
                this.addItem(item.text, item.value);
            }
        }

    }

    setValue(value: any): void {
        super.setValue(value);
        var selectEl: HTMLSelectElement = <HTMLSelectElement> this.getEl();
        selectEl.value = value;
    }

    getValue(): any {
        var selectEl: HTMLSelectElement = <HTMLSelectElement> this.getEl();
        return selectEl.value;
    }

    getShowText(): string {
        if (this.items) {
            var value = this.getValue();
            for (let item of this.items) {
                if (item.value.toString() == value.toString()) {
                    return item.text ? item.text : "";
                }
            }
        }
        return "";
    }

    private addItem(text?: any, value?: any) {
        var selectEl: HTMLSelectElement = <HTMLSelectElement> this.getEl();
        var optionEl: HTMLOptionElement = document.createElement("option");
        optionEl.text = text;
        optionEl.value = value;
        selectEl.appendChild(optionEl);
    }

    private createItems(strInitialValue: string): any {
        var aStr = strInitialValue.split(";");
        var items: any[] = [];
        for (let str of aStr) {
            var aItem = str.indexOf(',') > -1 ? str.split(",") : str.split(":");
            if (aItem.length == 1) {
                items.push(this.createItem(aItem[0], aItem[0]));
            } else if (aItem.length == 2) {
                items.push(this.createItem(aItem[0], aItem[1]));
            }
        }
        return items;
    }

    private createItem(value: string, text: any) {
        return {text: text, value: value};
    }
}