import AbstractDomElement from "../../dom/AbstractDomElement";
import DomUtil from "../../dom/DomUtil";
import SpanElement from "../../dom/element/SpanElement";
import SizeInfo from "../../struct/SizeInfo";
import AbstractControl from "./AbstractControl";
import DownArrow from "./DownArrow";
import TextEditor from "./TextEditor";

export default class ColorEditor extends AbstractControl<SpanElement> {

    private textEditor: TextEditor;

    private button: DownArrow;
    //private button: Button;
    private colorContainer: ColorContainer;

    constructor() {
        super(new SpanElement());
        this.textEditor = new TextEditor();
        this.button = new DownArrow();
        //this.button = new Button("...");
        this.getDomElement().addChild(this.textEditor.getDomElement());
        this.getDomElement().addChild(this.button.getDomElement());
        //this.button.setStyle('margin', '0px 0px 0px -24px');
        this.colorContainer = new ColorContainer();
        var self = this;
        this.button.addEventListener("click", function(event: any) {
            event = event || window.event;
            self.colorContainer.setValue(self.getValue());
            self.getDomElement().addChild(self.colorContainer);
            var {offsetBodyLeft, offsetBodyTop} = DomUtil.offsetBodyPosition(self.button.getEl());
            console.log(offsetBodyLeft + ":" + offsetBodyTop);
        }, true);

        this.colorContainer.addEventListener("click", (e: any) => {
            var el = e.target;
            if (el.classList.contains('property-color-item')) {
                var item: ColorItem = <ColorItem> self.colorContainer.findElement(el);
                self.setValue(item.getColor());
                self.getDomElement().removeChild(self.colorContainer);
                this.fnOnValueChange && this.fnOnValueChange(this);
            }
        }, true);
        this.colorContainer.addEventListener("blur", (e: any) => {
            var el = e.target;
            setTimeout(function (){
                self.getDomElement().removeChild(self.colorContainer);
            },1)
        }, true);
    }

    setValue(value: any): void {
        super.setValue(value);
        this.textEditor.setValue(value);
        this.textEditor.setStyle('background-color', value);
    }

    getValue(): any {
        return this.textEditor.getValue();
    }

    setHeight(height: SizeInfo) {
        this.textEditor.setHeight(height);
        this.button.setHeight(SizeInfo.valueOfPX(height.getValue() - 2));
    }

    setWidth(width: SizeInfo) {
        var w = width.getValue();
        this.textEditor.setWidth(SizeInfo.valueOfPX(w - 27));
        this.button.setWidth(SizeInfo.valueOfPX(27));
    }

    lostFocus() {
        this.getDomElement().removeChild(this.colorContainer);
    }
}

class ColorItem extends AbstractDomElement {
    private color: string;
    constructor(color: string) {
        super();
        this.color = color;
        this.addClass('property-color-item');
        this.setStyle('background', color);
        this.setStyle('width', '12px');
        this.setStyle('height', '12px');
        this.setStyle('margin', '1px');
        this.setStyle('cursor', 'pointer');
        this.setStyle('border-width', '1px');
    }
    public getColor(): string {
        return this.color;
    }
}

class ColorContainer extends AbstractDomElement {
    private width: number = 140;
    private color_array = [
        "#ffffff", "#e5e4e4", "#d9d8d8", "#c0bdbd", "#a7a4a4", "#8e8a8b", "#827e7f", "#767173", "#5c585a", "#000000",
        "#fefcdf", "#fef4c4", "#feed9b", "#fee573", "#ffed43", "#f6cc0b", "#f6cc0b", "#c9a601", "#ad8e00", "#8c7301",
        "#ffded3", "#ffc4b0", "#ff9d7d", "#ff7a4e", "#ff6600", "#e95d00", "#d15502", "#ba4b01", "#a44201", "#8d3901",
        "#ffd2d0", "#ffbab7", "#fe9a95", "#ff7a73", "#ff483f", "#fe2419", "#f10b00", "#d40a00", "#940000", "#6d201b",
        "#ffdaed", "#ffb7dc", "#ffa1d1", "#ff84c3", "#ff57ac", "#fd1289", "#ec0078", "#d6006d", "#bb005f", "#9b014f",
        "#fcd6fe", "#fbbcff", "#f9a1fe", "#f784fe", "#f564fe", "#f546ff", "#f328ff", "#d801e5", "#c001cb", "#8f0197",
        "#e2f0fe", "#c7e2fe", "#add5fe", "#92c7fe", "#6eb5ff", "#48a2ff", "#2690fe", "#0162f4", "#013add", "#0021b0",
        "#d3fdff", "#acfafd", "#7cfaff", "#4af7fe", "#1de6fe", "#01deff", "#00cdec", "#01b6de", "#00a0c2", "#0084a0",
        "#edffcf", "#dffeaa", "#d1fd88", "#befa5a", "#a8f32a", "#8fd80a", "#79c101", "#3fa701", "#307f00", "#156200",
        "#d4c89f", "#daad88", "#c49578", "#c2877e", "#ac8295", "#c0a5c4", "#969ac2", "#92b7d7", "#80adaf", "#9ca53b",
    ];

    constructor() {
        super();
        this.setStyle('position', 'absolute');
        this.setStyle('z-index', '66666666');
        this.setStyle('display', 'flex');
        this.setStyle('width', this.width + 'px');
        this.setStyle('height', '160px');
        this.setStyle('margin', '5px');
        this.setStyle('flex-direction', 'row');
        this.setStyle('flex-wrap', 'wrap');
        this.setStyle('justify-content', 'center');
        this.setStyle('align-items', 'center');
        this.setAttr("tabindex","0")
        this.setStyle('background-color', '#cec7c7');
        // 遍历数组，添加pick按钮至容器
        for (let color of this.color_array) {
            var colorItem = new ColorItem(color);
            this.addChild(colorItem);
        }
    }

    setValue(color: string): void {
        for (let child of this.getChildren()) {
            var item = <ColorItem> child;
            item.removeClass('property-color-item-focus');
            if (color == item.getColor()) {
                item.addClass('property-color-item-focus');
            }
        }
    }

    setLocation(left: number, top: number): void {
        this.setStyle('left', left + 'px');
        this.setStyle('top', top + 'px');
    }

    public getWidth(): number {
        return this.width;
    }
}