import { IToggleListener } from "../../dom/listener/Listeners";
import BooleanControl from "./BooleanControl";
import ToggleArrowLabel from "./ToggleArrowLabel";

export default class Collapse extends BooleanControl<ToggleArrowLabel> {
    constructor(caption: string, bExpand: boolean, 
        clsExpandIcon: string = ToggleArrowLabel.DEFAULT_EXPAND_ICON,
        clsCollapseIcon: string = ToggleArrowLabel.DEFAULT_COLLAPSE_ICON) {
        super(new ToggleArrowLabel(caption, bExpand, clsExpandIcon, clsCollapseIcon));

        var skin = this.styleFactory.getCollapseSkin();
        this.getDomElement().addClass(skin.collapse);
        this.getDomElement().addTextClass(skin.collapse_text);
    }

    setToggleListener(toggleListener: IToggleListener) {
        this.getDomElement().setToggleListener(toggleListener);
    }

    setTextStyle(name: string, value: string) {
        this.getDomElement().setTextStyle(name, value);
    }


} 
