import DomUtil from "../../dom/DomUtil";
import DomElement from "../../dom/element/DomElement";
import GlobalStyle from "../../style/GlobalStyle";
import BooleanControl from './BooleanControl';

export default class Checkbox extends BooleanControl<DomElement> {

    private static TEMPLATE: string =
        `<label class="${GlobalStyle.CLS_YG_CHECKBOX}">
        <span class="${GlobalStyle.CLS_YG_CHECKBOX_INPUT}">
            <input type="checkbox" class="${GlobalStyle.CLS_YG_CHECKBOX_ORIGINAL}">
            <span class="${GlobalStyle.CLS_YG_CHECKBOX_INNER}"></span>
        </span>
        <span class="${GlobalStyle.CLS_YG_CHECKBOX_LABEL}"/>
    </label>`;

    private $el: JQuery;
    private $elInput: JQuery;
    private $elOriginalInput: JQuery;
    private $elLabel: JQuery;

    constructor(text: string) {
        super(new DomElement(DomUtil.parseEl(Checkbox.TEMPLATE)));
        this.$el = $(this.getDomElement().getEl());
        this.$elInput = $(`.${GlobalStyle.CLS_YG_CHECKBOX_INPUT}`, this.$el);
        this.$elOriginalInput = $(`.${GlobalStyle.CLS_YG_CHECKBOX_ORIGINAL}`, this.$el);
        this.$elLabel = $(`.${GlobalStyle.CLS_YG_CHECKBOX_LABEL}`, this.$el);
        this.$elLabel.text(text);
        this.$elOriginalInput.on('click', () => {
            var bCheck = this.getValue();
            this.setChecked(!bCheck);
        });
        this.initStyle();
    }

    private initStyle() {
        var skin = this.styleFactory.getCheckboxSkin();
        this.$el.addClass(skin.checkbox);
        this.$elInput.addClass(skin.checkbox_input);
        $(`.${GlobalStyle.CLS_YG_CHECKBOX_INNER}`, this.$el).addClass(skin.checkbox_inner);
        this.$elOriginalInput.addClass(skin.checkbox_original);
        this.$elLabel.addClass(skin.checkbox_label);
    }

    isChecked(): boolean {
        return this.$elOriginalInput.prop('checked');
    }

    setChecked(checked: boolean) {
        this.setValue(checked);
        this.$elInput.removeClass(GlobalStyle.CLS_ISCHECKED);
        checked && this.$elInput.addClass(GlobalStyle.CLS_ISCHECKED);
        this.$elOriginalInput.prop('checked', checked);
    }
}

/*
<label class="el-checkbox is-checked">
    <span class="el-checkbox__input is-checked">
        <span class="el-checkbox__inner"></span>
        <input type="checkbox" aria-hidden="false" class="el-checkbox__original" value="复选框 A">
    </span>
    <span class="el-checkbox__label">复选框 A</span>
</label>
*/

//https://www.bulmacss.cn/doc/read/93.html