import ButtonElement from "../../dom/element/ButtonElement";
import AbstractControl from "./AbstractControl";


export default class Button extends AbstractControl<ButtonElement> {

    constructor(text: string = "") {
        super(new ButtonElement());
        this.setCaption(text);
    }

    setOnClickListener(fun: any): void {
        this.getDomElement().addEventListener("click", fun, false);
    }

    setCaption(text: string): void {
        this.getDomElement().setText(text);
    }
}