import AbstractDomElement from "../../dom/AbstractDomElement";
import AbstractControl from "./AbstractControl";

export default class BooleanControl<T extends AbstractDomElement> extends AbstractControl<T> {

    constructor(element: T) {
        super(element);
        this.setValue(true);
    }

    isChecked(): boolean {
        return this.getValue();
    }

    setChecked(bChecked: boolean) {
        this.setValue(bChecked);
    }
}