import AbstractDomElement from "../../dom/AbstractDomElement";
import JComponent from "../JComponent";

export default abstract class AbstractControl<T extends AbstractDomElement> extends JComponent<T> {

    private value?: any;

    protected fnOnValueChange: any;

    constructor(element: T) {
        super(element);

        this.getDomElement().addEventListener("change", (event: any) => {
            this.fnOnValueChange && this.fnOnValueChange(this);
        });

       /* $(this.getDomElement()).change(() => {
            this.fnOnValueChange && this.fnOnValueChange(this);
        });*/
    }

    initControl(initialValue: any) {   
    }

    setOnButtonClick(fn: Function): void {
    }

    setOnValueChanged(fn: Function): void {
        this.fnOnValueChange = fn;
    }

    setEditable(editable: boolean): void {
    }

    setValue(value: any): void {
        this.value = value;
    }

    getValue(): any {
        return this.value;
    }

    getShowText(): any {
        return this.value;
    }

    setShowText(showText: string): void {
    }

    caretLast(): void {
    }

    protected getInputDomElement(): AbstractDomElement {
        return this.getDomElement();
    }
}