import JComponent from "../../../JComponent";
import JPanel from "../JPanel";
import BaseLayout from "./BaseLayout";
import BaseLayoutItem from "./item/BaseLayoutItem";

export default class StackLayout extends BaseLayout {

    protected layoutChildren(container: JPanel<BaseLayoutItem, StackLayout>) {
        for (let layoutItem of this.layoutItems.getList()) {
            let node: JComponent<any> | null = layoutItem.getNode();
            if (node) {
                node.display();
                node.setStyle('position', 'absolute');
            }
        }
    }
}