
import { ELayoutDirection, ESizeType } from "../../../../enum/Enums";
import SizeInfo from "../../../../struct/SizeInfo";
import JComponent from "../../../JComponent";
import Panel from "../JPanel";
import AbstractLayout from "./AbstractLayout";
import FlexLayoutItem from "./item/FlexLayoutItem";


export default class H5FlexLayout extends AbstractLayout<FlexLayoutItem> {

    private isVerticalDirection = false;

    private flexDirection: ELayoutDirection = ELayoutDirection.Row;

    constructor(direction: ELayoutDirection) {
        super();
        this.flexDirection = direction;
        this.isVerticalDirection = (direction == ELayoutDirection.Column);
    }

    layout(container: Panel<FlexLayoutItem, H5FlexLayout>): void {
        container.setStyle("display", "flex");
        container.setStyle("flex-flow", this.flexDirection);
        this.vGap && container.setStyle("row-gap", this.vGap.toString());
        this.hGap && container.setStyle("column-gap", this.hGap.toString());
        this.setSizeStyleValue(container, container.getWidth(), container.getHeight());
        this.layoutChildren(container);
    }

    protected layoutChildren(container: Panel<FlexLayoutItem, H5FlexLayout>) {
        for (let layoutItem of this.layoutItems.getList()) {
            let node: JComponent<any> | null = layoutItem.getNode();
            this.setSizeStyleValue(node, layoutItem.getWidth(), layoutItem.getHeight());
            node && node.display();
        }
    }

    private setSizeStyleValue(node: JComponent<any> | null, width: SizeInfo, height: SizeInfo): void {
        if (node == null) return;
        var size: SizeInfo = this.isVerticalDirection ? height : width;
        if (size == SizeInfo.NONE) {
            return;
        }
        var styleName: string = this.isVerticalDirection ? 'height' : 'width';
        if (size.getType() == ESizeType.FlexScale) {
            node.setStyle("flex", size.getValue());
        } else {
            node.setStyle(styleName, size.toString());
        }
    }

    protected createLayoutItem(): FlexLayoutItem {
        return new FlexLayoutItem();
    }
}