import JComponent from "../../../JComponent";
import JPanel from "../JPanel";
import AbstractLayout from "./AbstractLayout";
import BaseLayoutItem from "./item/BaseLayoutItem";

export default class BaseLayout extends AbstractLayout<BaseLayoutItem> {
    constructor() {
        super();
    }

    layout(container: JPanel<BaseLayoutItem, BaseLayout>): void {
        this.layoutChildren(container);
    }

    protected layoutChildren(container: JPanel<BaseLayoutItem, BaseLayout>) {
        for (let layoutItem of this.layoutItems.getList()) {
            let node: JComponent<any> | null = layoutItem.getNode();
            node && node.display();
        }
    }

    protected createLayoutItem(): BaseLayoutItem {
        return new BaseLayoutItem();
    }
}