
import { IAreaRange } from "../../../../enum/Enums";
import ArrayList from "../../../../struct/ArrayList";
import SizeInfo from "../../../../struct/SizeInfo";
import JComponent from "../../../JComponent";
import Panel from "../JPanel";
import BaseLayoutItem from "./item/BaseLayoutItem";
/**
 * 布局抽象类
 * 
 */
export default abstract class AbstractLayout<T extends BaseLayoutItem> {

    private areaRange: IAreaRange | null = null;

    protected vGap: SizeInfo | undefined;

    protected hGap: SizeInfo | undefined;

    protected layoutItems: ArrayList<T>;

    constructor() {
        this.layoutItems = new ArrayList<T>();
    }

    setAreaRange(areaRange: IAreaRange) {
        this.areaRange = areaRange;
    }

    getAreaRange(): IAreaRange | null {
        return this.areaRange;
    }

    public setVGap(gap: SizeInfo): void {
        this.vGap = gap;
    }

    public setHGap(gap: SizeInfo): void {
        this.hGap = gap;
    }

    public addLayoutItem(node: JComponent<any> | null): T {
        var item = this.createLayoutItem();
        item.setNode(node);
        this.layoutItems.add(item);
        return item;
    }

    public removeLayoutItem(node: JComponent<any>): void {
        for (let item of this.layoutItems.getList()) {
            if (item.getNode() == node) {
                item.setNode(null);
                this.layoutItems.remove(item);
                return;
            }
        }
    }

    public removeAll(): void {
        for (let item of this.layoutItems.getList()) {
            item.setNode(null);
        }
        this.layoutItems.clearAll()
    }

    public getLayoutItem(index: number): T {
        return this.layoutItems.get(index);
    }

    public getLayoutItems(): T[] {
        return this.layoutItems.getList();
    }

    /**
     * 布局面板组件
     * 
     * @param container 容器
     */
    public abstract layout(container: Panel<T, AbstractLayout<T>>): void;

    protected abstract createLayoutItem(): T;
}