import AbstractDomElement from "../../../dom/AbstractDomElement";

/**
 * 
 */
export default class PopupPanel extends AbstractDomElement {

    private content?: AbstractDomElement;

    private bHide = true;

    constructor() {
        super();
        this.hide(); 
        this.bHide = true;
    }

    setContent(content: AbstractDomElement): void {
        this.clearChildren();
        this.content = content;
        this.addChild(content);
    }

    private initSytles(left: number, top: number, width: number, height: number): void {
        this.setStyle('display', 'block');
        this.setStyle('top', top + 'px');
        this.setStyle('left', left + 'px');
        this.setStyle('z-index', 99);
        this.setStyles({width: width + 'px', 'height': height + 'px'});
        //this.setStyle('background-color', '#EEE');
        //this.setStyle('position', 'relative');
        this.setStyle('position', 'absolute');
    }

    hide(): void {
        this.bHide = true;
        this.setStyle('display', 'none');
        var parent = this.getEl().parentElement;
        if (parent) {
            parent.removeChild(this.getEl()); 
        }
    }

    show(left: number, top: number, width: number, height: number, parent: HTMLElement): void {
        this.bHide = false;
        this.initSytles(left, top, width, height);
        this.setStyle('display', 'block');
        if (!parent.contains(this.getEl())) {
            parent.appendChild(this.getEl());
            this.initSytles(left, top, width, height);
            this.setStyle('display', 'block');
        }
          // this.getEl().focus();
    }

    isShowing() {
        return !this.bHide;
    }
}