import SizeInfo from "../../../struct/SizeInfo";
import JComponent from "../../JComponent";
import JPanel from "./JPanel";
import SplitLayoutItem from "./layout/item/SplitLayoutItem";
import SplitLayout from "./layout/SplitLayout";

export default class HSplitPanel extends JPanel<SplitLayoutItem, SplitLayout> {

    constructor(... sizes: SizeInfo[]) {
        super(new SplitLayout(false, sizes));
    }

    setNode(index: number, node: JComponent<any>) {
        var layoutItem = this.getLayout().getLayoutItem(index);
        layoutItem && layoutItem.setNode(node);
    }

}