import { ELayoutDirection } from "../../../enum/Enums";
import JComponent from "../../JComponent";
import JPanel from "./JPanel";
import H5FlexLayout from "./layout/H5FlexLayout";
import FlexLayoutItem from "./layout/item/FlexLayoutItem";

export default class H5VFlexPanel extends JPanel<FlexLayoutItem, H5FlexLayout> {

    constructor() {
        super(new H5FlexLayout(ELayoutDirection.Column));
    }

    public addComponent(component: JComponent<any>, ... others: JComponent<any>[]): FlexLayoutItem {
        var layoutItem = super.addComponent(component);
        layoutItem.setWidth(component.getWidth());
        layoutItem.setHeight(component.getHeight());
        if (others) {
            for (let comp of others) {
                layoutItem = super.addComponent(comp);
                layoutItem.setWidth(comp.getWidth());
                layoutItem.setHeight(comp.getHeight());
            }
        }
        return layoutItem;
    }
}