import SizeInfo from "../../../struct/SizeInfo";
import JComponent from "../../JComponent";
import JPanel from "./JPanel";
import H5GridLayout from "./layout/H5GridLayout";
import GridLayoutItem from "./layout/item/GridLayoutItem";

export default class H5GridPanel extends JPanel<GridLayoutItem, H5GridLayout> {

    constructor() {
        super(new H5GridLayout());
    }

    public initGrid(rows: SizeInfo[], columns: SizeInfo[], rowGap: SizeInfo | null = SizeInfo.PX2, colGap: SizeInfo | null = SizeInfo.PX2): void {
        rowGap && this.setRowGap(rowGap);
        colGap && this.setColumnGap(colGap);
        for (let columnSize of columns) {
            this.addColumn(columnSize);
        }

        for (let rowSize of rows) {
            this.addRow(rowSize);
        }
    }

    public addColumn(width: SizeInfo): void {
        this.getLayout().addColumn(width);
    }

    public addRow(height: SizeInfo): void {
        this.getLayout().addRow(height);
    }

    public setRowGap(rowGap: SizeInfo): void {
        this.getLayout().setVGap(rowGap);
    }

    public setColumnGap(colGap: SizeInfo): void {
        this.getLayout().setHGap(colGap);
    }

    public addComponent(component: JComponent<any>, x: number = 0,
        y: number = 0, xSpan: number = 1, ySpan: number = 1): GridLayoutItem {
        var layoutItem = super.addComponent(component);
        layoutItem.setX(x);
        layoutItem.setY(y);
        layoutItem.setXSpan(xSpan);
        layoutItem.setYSpan(ySpan);
        return layoutItem;
    }
}