import SizeInfo from "../../../struct/SizeInfo";
import JComponent from "../../JComponent";
import H5GridPanel from "./H5GridPanel";
import GridLayoutItem from "./layout/item/GridLayoutItem";

export default class BorderPanel extends H5GridPanel {

    private centerNode?: JComponent<any>;

    private topNode?: JComponent<any>;

    private leftNode?: JComponent<any>;

    private rightNode?: JComponent<any>;

    private bottomNode?: JComponent<any>;

    constructor(left:number, right:number, top:number, bottom:number) {
        super();
        this.setStyle("overflow", "hidden");

        this.initGrid(
            [SizeInfo.valueOfPX(top), SizeInfo.AUTO_SIZE, SizeInfo.valueOfPX(bottom)],
            [SizeInfo.valueOfPX(left), SizeInfo.AUTO_SIZE, SizeInfo.valueOfPX(right)],
            null, null
        );
    }

    setTop(topElement: JComponent<any>): GridLayoutItem {
        this.topNode && this.removeComponent(this.topNode);
        this.topNode = topElement;
        return this.addComponent(topElement, 1, 1, 4, 1);
    }

    setLeft(leftElement: JComponent<any>): GridLayoutItem {
        this.leftNode && this.removeComponent(this.leftNode);
        this.leftNode = leftElement;
        return this.addComponent(leftElement, 1, 2, 1, 1);
    }

    hasLeft(): boolean {
        return !!this.leftNode;
    }

    setRight(rightElement: JComponent<any>): GridLayoutItem {
        this.rightNode && this.removeComponent(this.rightNode);
        this.rightNode = rightElement;
        return this.addComponent(rightElement, 3, 2, 1, 1);
    }

    setBottom(bottomElement: JComponent<any>): GridLayoutItem {
        this.bottomNode && this.removeComponent(this.bottomNode);
        this.bottomNode = bottomElement;
        return this.addComponent(bottomElement, 1, 3, 4, 1);
    }

    setCenter(centerElement: JComponent<any>): GridLayoutItem {
        if (this.centerNode) {
            this.removeComponent(this.centerNode);
        }
        this.centerNode = centerElement;
        return this.addComponent(centerElement, 2, 2, 1, 1);
    }
}